/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import teams.domain.AdminMember;
import teams.domain.FederatedUser;
import teams.domain.Membership;
import teams.domain.Role;
import teams.domain.Team;

public class TeamSummary {
    private Long id;
    private String name;
    private String urn;
    private int membershipCount;
    private String description;
    private Role role;
    private int joinRequestsCount;
    private int invitationsCount;
    private boolean viewable;
    private boolean hideMembers;
    private List<AdminMember> admins = new ArrayList();

    public TeamSummary(Team team, FederatedUser user, boolean includeAdmins) {
        this.id = team.getId();
        this.urn = team.getUrn();
        this.name = team.getName();
        this.membershipCount = team.getMembershipCount();
        this.description = team.getDescription();
        this.viewable = team.isViewable();
        this.hideMembers = team.isHideMembers();
        Optional<Membership> membershipOptional = team.getMemberships().stream().filter(membership -> membership.getUrnPerson().equals(user.getUrn())).findAny();
        this.role = membershipOptional.map(Membership::getRole).orElse(null);
        if (includeAdmins) {
            this.admins = team.getMemberships().stream().filter(membership -> membership.getRole().equals((Object)Role.ADMIN) || membership.getRole().equals((Object)Role.OWNER)).map(membership -> new AdminMember(membership.getPerson())).collect(Collectors.toList());
        }
    }

    @JsonIgnore
    public void joinRequestsCount(int count) {
        this.joinRequestsCount = count;
    }

    @JsonIgnore
    public void invitationsCount(int count) {
        this.invitationsCount = count;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getUrn() {
        return this.urn;
    }

    @Generated
    public int getMembershipCount() {
        return this.membershipCount;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Role getRole() {
        return this.role;
    }

    @Generated
    public int getJoinRequestsCount() {
        return this.joinRequestsCount;
    }

    @Generated
    public int getInvitationsCount() {
        return this.invitationsCount;
    }

    @Generated
    public boolean isViewable() {
        return this.viewable;
    }

    @Generated
    public boolean isHideMembers() {
        return this.hideMembers;
    }

    @Generated
    public List<AdminMember> getAdmins() {
        return this.admins;
    }
}

