/*
 * Decompiled with CFR 0.152.
 */
package teams.mail;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import teams.mail.MailBox;

@Configuration
@EnableConfigurationProperties(value={MailProperties.class})
public class MailConfiguration {
    @Value(value="${email.from}")
    private String emailFrom;
    @Value(value="${email.base-url}")
    private String baseUrl;
    @Value(value="${teams.product-name}")
    private String productName;
    @Autowired
    private JavaMailSender mailSender;

    @Bean
    public MailBox mailSenderProd() {
        return new MailBox(this.mailSender, this.emailFrom, this.baseUrl, this.productName);
    }
}

