/*
 * Decompiled with CFR 0.152.
 */
package teams.voot;

import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.stereotype.Component;
import teams.domain.ExternalTeam;

@Component
@Profile(value={"!dev"})
public class VootClient {
    private static final Logger LOG = LoggerFactory.getLogger(VootClient.class);
    private final String serviceUrl;
    private OAuth2RestTemplate vootService;

    public VootClient(@Value(value="${voot.accessTokenUri}") String accessTokenUri, @Value(value="${voot.clientId}") String clientId, @Value(value="${voot.clientSecret}") String clientSecret, @Value(value="${voot.scopes}") String spaceDelimitedScopes, @Value(value="${voot.serviceUrl}") String serviceUrl) {
        this.serviceUrl = serviceUrl;
        this.vootService = new OAuth2RestTemplate(this.vootConfiguration(clientId, clientSecret, accessTokenUri, spaceDelimitedScopes));
    }

    public List<ExternalTeam> teams(String personUrn) {
        String personUrnEncoded = URLEncoder.encode(personUrn, Charset.defaultCharset().name());
        List<ExternalTeam> externalTeams = ((List)this.vootService.exchange(RequestEntity.get((URI)URI.create(String.format("%s/internal/external-groups/%s/", this.serviceUrl, personUrnEncoded))).build(), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).getBody()).stream().map(map -> new ExternalTeam((String)map.get("description"), (String)map.get("sourceID"), (String)map.get("id"), (String)map.get("displayName"))).collect(Collectors.toList());
        LOG.debug("Result from VOOT external teams {}", externalTeams);
        return externalTeams;
    }

    private OAuth2ProtectedResourceDetails vootConfiguration(String clientId, String clientSecret, String accessTokenUri, String spaceDelimitedScopes) {
        ClientCredentialsResourceDetails details = new ClientCredentialsResourceDetails();
        details.setId("voot");
        details.setClientId(clientId);
        details.setClientSecret(clientSecret);
        details.setAccessTokenUri(accessTokenUri);
        details.setScope(Arrays.asList(spaceDelimitedScopes.split(" ")));
        return details;
    }
}

