/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import java.util.List;
import java.util.stream.Collectors;
import teams.domain.AdminMember;
import teams.domain.FederatedUser;
import teams.domain.Invitation;
import teams.domain.InvitationMessage;
import teams.domain.Role;
import teams.domain.Team;

public class InvitationInfo {
    private String inviter;
    private Long expiryDate;
    private boolean accepted;
    private boolean expired;
    private boolean declined;
    private boolean alreadyMember;
    private InvitationMessage latestInvitationMessage;
    private Long teamId;
    private String teamName;
    private String teamDescription;
    private String invitationEmail;
    private Role intendedRole;
    private int daysValid;
    private List<AdminMember> admins;

    public InvitationInfo(Invitation invitation, FederatedUser federatedUser) {
        this.latestInvitationMessage = invitation.getLatestInvitationMessage();
        Team team = invitation.getTeam();
        this.teamId = team.getId();
        this.teamName = team.getName();
        this.teamDescription = team.getDescription();
        this.inviter = invitation.getLatestInvitationMessage().getPerson().getName();
        this.invitationEmail = invitation.getEmail();
        this.intendedRole = invitation.getIntendedRole();
        this.expiryDate = invitation.getExpiryDate() != null ? Long.valueOf(invitation.getExpiryDate().getEpochSecond()) : null;
        this.declined = invitation.isDeclined();
        this.accepted = invitation.isAccepted();
        this.expired = invitation.expired();
        this.alreadyMember = team.member(federatedUser.getUrn()).isPresent();
        this.daysValid = invitation.daysValid();
        this.admins = team.getMemberships().stream().filter(membership -> membership.getRole().equals((Object)Role.ADMIN)).map(membership -> new AdminMember(membership.getPerson())).collect(Collectors.toList());
    }

    public String getInviter() {
        return this.inviter;
    }

    public Long getExpiryDate() {
        return this.expiryDate;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public boolean isDeclined() {
        return this.declined;
    }

    public boolean isAlreadyMember() {
        return this.alreadyMember;
    }

    public InvitationMessage getLatestInvitationMessage() {
        return this.latestInvitationMessage;
    }

    public Long getTeamId() {
        return this.teamId;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public String getTeamDescription() {
        return this.teamDescription;
    }

    public String getInvitationEmail() {
        return this.invitationEmail;
    }

    public Role getIntendedRole() {
        return this.intendedRole;
    }

    public int getDaysValid() {
        return this.daysValid;
    }

    public List<AdminMember> getAdmins() {
        return this.admins;
    }
}

