/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import teams.domain.ExternalTeam;
import teams.domain.Feature;
import teams.domain.Person;

public class FederatedUser
extends User {
    private String groupNameContext;
    private String productName;
    private Person person;
    private List<ExternalTeam> externalTeams;
    private Map<Feature, Boolean> featureToggles;

    public FederatedUser(Person person, String groupNameContext, String productName, List<ExternalTeam> externalTeams, Map<Feature, Boolean> featureToggles) {
        super(person.getName(), "N/A", person.isGuest() ? Collections.singletonList(new SimpleGrantedAuthority("ROLE_USER")) : Arrays.asList(new SimpleGrantedAuthority("ROLE_USER"), new SimpleGrantedAuthority("ROLE_ADMIN")));
        this.person = person;
        this.groupNameContext = groupNameContext;
        this.productName = productName;
        this.externalTeams = externalTeams;
        this.featureToggles = featureToggles;
    }

    public String getUrn() {
        return this.person.getUrn();
    }

    public boolean featureEnabled(Feature feature) {
        return this.featureToggles.getOrDefault(feature, Boolean.FALSE);
    }

    public String getGroupNameContext() {
        return this.groupNameContext;
    }

    public String getProductName() {
        return this.productName;
    }

    public Person getPerson() {
        return this.person;
    }

    public List<ExternalTeam> getExternalTeams() {
        return this.externalTeams;
    }

    public Map<Feature, Boolean> getFeatureToggles() {
        return this.featureToggles;
    }
}

