/*
 * Decompiled with CFR 0.152.
 */
package teams.voot;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import teams.domain.ExternalTeam;
import teams.domain.Membership;
import teams.domain.Team;
import teams.exception.ResourceNotFoundException;
import teams.repository.ExternalTeamRepository;
import teams.repository.MembershipRepository;
import teams.repository.TeamRepository;
import teams.voot.Group;
import teams.voot.Member;

@RestController
public class VootApiController {
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private MembershipRepository membershipRepository;
    @Autowired
    private ExternalTeamRepository externalTeamRepository;

    @GetMapping(value={"api/voot/group/{localGroupId}"})
    public Group findByLocalGroupId(@PathVariable(value="localGroupId") String localGroupId) {
        Team team = (Team)this.resolveOptionalOrThrow(this.teamRepository.findByUrnOrderById(localGroupId), localGroupId);
        return this.convertTeamToGroup(team);
    }

    @GetMapping(value={"api/voot/linked-locals"})
    public Set<Group> linkedLocalTeamsGroup(@RequestParam(value="externalGroupIds") String fullyQualifiedExternalGroupIds) {
        List<String> identifiers = Arrays.asList(fullyQualifiedExternalGroupIds.split(","));
        return this.externalTeamRepository.findByIdentifierIn(identifiers).stream().map(ExternalTeam::getTeams).flatMap(Collection::stream).map(arg_0 -> this.convertTeamToGroup(arg_0)).collect(Collectors.toSet());
    }

    @GetMapping(value={"api/voot/linked-externals"})
    public List<String> linkedExternalGroupIds(@RequestParam(value="teamId") String localGroupUrn) {
        return this.externalTeamRepository.findByTeamsUrn(localGroupUrn).stream().map(ExternalTeam::getIdentifier).collect(Collectors.toList());
    }

    @GetMapping(value={"api/voot/members/{localGroupId}"})
    public List<Member> getMembers(@PathVariable(value="localGroupId") String localGroupId) {
        Team team = (Team)this.resolveOptionalOrThrow(this.teamRepository.findByUrn(localGroupId), localGroupId);
        return team.getMemberships().stream().map(arg_0 -> this.convertMembershipToMember(arg_0)).collect(Collectors.toList());
    }

    @GetMapping(value={"api/voot/groups"})
    public List<Group> getAllGroups() {
        return StreamSupport.stream(this.teamRepository.findAll().spliterator(), false).filter(Team::isViewable).map(arg_0 -> this.convertTeamToGroup(arg_0)).collect(Collectors.toList());
    }

    @GetMapping(value={"api/voot/user/{uid}/groups"})
    public List<Group> getGroupsForMember(@PathVariable(value="uid") String uid) {
        return this.teamRepository.findByMembershipsUrnPersonOrderById(uid).stream().map(arg_0 -> this.convertTeamToGroup(arg_0)).collect(Collectors.toList());
    }

    @GetMapping(value={"api/voot/user/{uid}/groups/{groupId}"})
    public Group getGroupsForMemberAndTeamUrn(@PathVariable(value="uid") String uid, @PathVariable(value="groupId") String groupId) {
        Optional membershipOptional = this.membershipRepository.findByUrnTeamAndUrnPerson(groupId, uid);
        Membership membership = (Membership)membershipOptional.orElseThrow(() -> new ResourceNotFoundException(String.format("Membership for team %s and Person %s not found", groupId, uid)));
        return this.convertTeamToGroup(membership.getTeam());
    }

    private Member convertMembershipToMember(Membership membership) {
        return new Member(membership.getUrnPerson(), membership.getPerson().getName(), membership.getPerson().getEmail());
    }

    private <T> T resolveOptionalOrThrow(Optional<T> optional, String urn) {
        return optional.orElseThrow(() -> new ResourceNotFoundException(String.format("Non existent Team with urn %s", urn)));
    }

    private Group convertTeamToGroup(Team team) {
        return new Group(team.getUrn(), team.getName(), team.getDescription(), "member");
    }
}

