/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import org.springframework.util.StringUtils;
import teams.domain.JoinRequest;
import teams.domain.Membership;

@Entity(name="persons")
public class Person {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    @NotNull
    private String urn;
    @Column
    private String name;
    @Column
    private String email;
    @Column
    private Instant created;
    @Column
    private Instant lastLoginDate;
    @Column
    private boolean guest;
    @OneToMany(mappedBy="person", orphanRemoval=true)
    @JsonIgnore
    private Set<JoinRequest> joinRequests = new HashSet();
    @OneToMany(mappedBy="person", orphanRemoval=true)
    @JsonIgnore
    private Set<Membership> memberships = new HashSet();

    public Person(String urn, String name, String email, boolean isGuest) {
        this.urn = urn;
        this.name = name;
        this.email = email;
        this.guest = isGuest;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setGuest(boolean guest) {
        this.guest = guest;
    }

    public void setLastLoginDate(Instant lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    @JsonIgnore
    public boolean isValid() {
        return StringUtils.hasText((String)this.urn) && StringUtils.hasText((String)this.name) && StringUtils.hasText((String)this.email);
    }

    public String toString() {
        return "Person{urn='" + this.urn + '\'' + ", name='" + this.name + '\'' + ", email='" + this.email + '\'' + ", guest=" + this.guest + '}';
    }

    public Long getId() {
        return this.id;
    }

    public String getUrn() {
        return this.urn;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public Instant getCreated() {
        return this.created;
    }

    public Instant getLastLoginDate() {
        return this.lastLoginDate;
    }

    public boolean isGuest() {
        return this.guest;
    }

    public Set<JoinRequest> getJoinRequests() {
        return this.joinRequests;
    }

    public Set<Membership> getMemberships() {
        return this.memberships;
    }

    public Person() {
    }
}

