/*
 * Decompiled with CFR 0.152.
 */
package teams.repository;

import java.util.List;
import java.util.Optional;
import javax.persistence.OptimisticLockException;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import teams.domain.Invitation;

@Repository
public interface InvitationRepository
extends CrudRepository<Invitation, Long> {
    @EntityGraph(value="findFirstByInvitationHash", type=EntityGraph.EntityGraphType.LOAD, attributePaths={"invitationMessages", "team", "team.memberships"})
    public Optional<Invitation> findFirstByInvitationHash(String var1);

    @Query(value="select i.team.id, count(i.id) from teams.domain.Invitation i where i.team.id in :teamIds and i.accepted = false group by i.team")
    public List<Object[]> countInvitationsByTeamId(@Param(value="teamIds") List<Long> var1);

    @Transactional(noRollbackFor={OptimisticLockException.class})
    @Modifying
    @Query(value="DELETE FROM invitations WHERE timestamp < :epochMilliseconds", nativeQuery=true)
    public int deleteExpiredInvitations(@Param(value="epochMilliseconds") long var1);

    @EntityGraph(value="findFirstById", type=EntityGraph.EntityGraphType.LOAD, attributePaths={"invitationMessages", "team", "team.memberships"})
    public Invitation findById(Long var1);
}

