/*
 * Decompiled with CFR 0.152.
 */
package teams.repository;

import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;
import teams.domain.Team;

@Repository
public interface TeamRepository
extends CrudRepository<Team, Long> {
    @EntityGraph(value="findByUrn", type=EntityGraph.EntityGraphType.LOAD, attributePaths={"memberships"})
    public Optional<Team> findByUrn(String var1);

    public Optional<Team> findByUrnOrderById(String var1);

    @EntityGraph(value="findByPublicLinkAndPublicLinkDisabled", type=EntityGraph.EntityGraphType.LOAD, attributePaths={"memberships"})
    public Optional<Team> findByPublicLinkAndPublicLinkDisabled(String var1, boolean var2);

    @EntityGraph(value="findByMembershipsUrnPerson", type=EntityGraph.EntityGraphType.LOAD, attributePaths={"memberships"})
    public List<Team> findByMembershipsUrnPerson(String var1);

    public List<Team> findByMembershipsUrnPersonOrderById(String var1);

    @Query(value="select distinct(teams.name), teams.id, teams.description, (select memberships.role from memberships where memberships.person_id = ?1 and memberships.team_id = teams.id) as role from teams as teams left outer join memberships on memberships.team_id = teams.id where upper(name) like ?2 and (teams.viewable = 1 or memberships.person_id = ?3) limit 100", nativeQuery=true)
    public List<Object[]> autocomplete(Long var1, String var2, Long var3);

    @Query(value="select distinct(teams.urn) from teams where urn = ? LIMIT 1", nativeQuery=true)
    public List<Object> existsByUrn(String var1);

    @EntityGraph(value="findById", type=EntityGraph.EntityGraphType.LOAD, attributePaths={"memberships"})
    public Team findById(Long var1);

    @EntityGraph(value="findFirstById", type=EntityGraph.EntityGraphType.LOAD, attributePaths={"memberships.person"})
    public Team findFirstById(Long var1);
}

