/*
 * Decompiled with CFR 0.152.
 */
package teams.shibboleth;

import java.util.List;
import java.util.Map;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import teams.domain.Feature;
import teams.domain.FederatedUser;
import teams.domain.Person;
import teams.voot.VootClient;

public class ShibbolethUserDetailService
implements AuthenticationUserDetailsService<PreAuthenticatedAuthenticationToken> {
    private final VootClient vootClient;
    private String groupNameContext;
    private String productName;
    private Map<Feature, Boolean> featureToggles;

    public ShibbolethUserDetailService(String groupNameContext, String productName, VootClient vootClient, Map<Feature, Boolean> featureToggles) {
        this.groupNameContext = groupNameContext;
        this.vootClient = vootClient;
        this.productName = productName;
        this.featureToggles = featureToggles;
    }

    public UserDetails loadUserDetails(PreAuthenticatedAuthenticationToken authentication) throws UsernameNotFoundException {
        Person person = (Person)Person.class.cast(authentication.getPrincipal());
        List externalTeams = this.vootClient.teams(person.getUrn());
        return new FederatedUser(person, this.groupNameContext, this.productName, externalTeams, this.featureToggles);
    }
}

