/*
 * Decompiled with CFR 0.152.
 */
package teams.api;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import teams.api.ApiController;
import teams.api.validations.JoinRequestValidator;
import teams.api.validations.MembershipValidator;
import teams.domain.ClientJoinRequest;
import teams.domain.FederatedUser;
import teams.domain.IdHolder;
import teams.domain.JoinRequest;
import teams.domain.Membership;
import teams.domain.Person;
import teams.domain.Role;
import teams.domain.Team;

@RestController
public class JoinRequestController
extends ApiController
implements MembershipValidator,
JoinRequestValidator {
    @GetMapping(value={"api/teams/join-requests/{id}"})
    public JoinRequest joinRequest(@PathVariable(value="id") Long id, FederatedUser federatedUser) {
        JoinRequest joinRequest = this.notNullGetJoinRequest(id);
        this.validateJoinRequest(joinRequest, federatedUser);
        return joinRequest;
    }

    @PostMapping(value={"api/teams/join-requests"})
    public JoinRequest join(@Validated @RequestBody ClientJoinRequest clientJoinRequest, FederatedUser federatedUser) throws MessagingException, IOException {
        Team team = this.teamById(clientJoinRequest.getTeamId(), true);
        Person person = federatedUser.getPerson();
        List existingJoinRequestForTheSameTeam = team.getJoinRequests().stream().filter(existingJoinRequest -> existingJoinRequest.getPerson().getId().equals(person.getId())).collect(Collectors.toList());
        List admins = this.admins(team);
        this.membershipNotAllowed(team, person);
        this.privateTeamDoesNotAllowMembers(team, person);
        JoinRequest joinRequest = new JoinRequest(person, team, clientJoinRequest.getMessage());
        this.joinRequestRepository.save((Object)joinRequest);
        this.joinRequestRepository.delete(existingJoinRequestForTheSameTeam);
        this.mailBox.sendJoinRequestMail(joinRequest, admins, federatedUser);
        this.log.info("Created joinRequest for team {} and person {}", (Object)team.getUrn(), (Object)person.getUrn());
        return joinRequest;
    }

    @PutMapping(value={"api/teams/join-requests/approve"})
    public Membership approve(@Validated @RequestBody IdHolder idHolder, FederatedUser federatedUser) throws MessagingException, IOException {
        JoinRequest joinRequest = this.notNullGetJoinRequestValidateMembership(idHolder.getId(), federatedUser);
        Person person = joinRequest.getPerson();
        Team team = joinRequest.getTeam();
        this.membershipNotAllowed(team, person);
        Membership newMembership = new Membership(Role.MEMBER, team, person);
        this.membershipRepository.save((Object)newMembership);
        this.mailBox.sendJoinRequestAccepted(joinRequest, federatedUser);
        this.joinRequestRepository.delete((Object)joinRequest);
        this.log.info("Approved joinRequest for team {} and person {} by {}", new Object[]{team.getUrn(), person.getUrn(), federatedUser.getUrn()});
        return newMembership;
    }

    @DeleteMapping(value={"api/teams/join-requests/reject/{id}"})
    public void reject(@PathVariable(value="id") Long id, FederatedUser federatedUser) throws MessagingException, IOException {
        JoinRequest joinRequest = this.notNullGetJoinRequestValidateMembership(id, federatedUser);
        this.mailBox.sendJoinRequestRejected(joinRequest, federatedUser);
        this.joinRequestRepository.delete((Object)joinRequest);
        this.log.info("Rejected joinRequest for team {} and person {} by {}", new Object[]{joinRequest.getTeam().getUrn(), joinRequest.getPerson().getUrn(), federatedUser.getUrn()});
    }

    @DeleteMapping(value={"api/teams/join-requests/{id}"})
    public void delete(@PathVariable(value="id") Long id, FederatedUser federatedUser) {
        JoinRequest joinRequest = this.notNullGetJoinRequest(id);
        this.validateJoinRequest(joinRequest, federatedUser);
        this.log.info("Deleted joinRequest for team {} and person {}", (Object)joinRequest.getTeam().getUrn(), (Object)federatedUser.getUrn());
        this.joinRequestRepository.delete((Object)joinRequest);
    }

    private JoinRequest notNullGetJoinRequest(Long id) {
        JoinRequest joinRequest = (JoinRequest)this.joinRequestRepository.findOne((Serializable)id);
        this.assertNotNull(JoinRequest.class.getSimpleName(), (Object)joinRequest, (Object)id);
        return joinRequest;
    }

    private JoinRequest notNullGetJoinRequestValidateMembership(Long id, FederatedUser federatedUser) {
        JoinRequest joinRequest = this.notNullGetJoinRequest(id);
        Membership membership = this.membership(joinRequest.getTeam(), federatedUser.getUrn());
        this.membersCanNotApproveJoinRequests(membership.getRole());
        return joinRequest;
    }
}

