/*
 * Decompiled with CFR 0.152.
 */
package teams.api;

import java.io.IOException;
import javax.mail.MessagingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import teams.api.validations.JoinRequestValidator;
import teams.api.validations.TeamValidator;
import teams.domain.FederatedUser;
import teams.domain.Membership;
import teams.domain.Person;
import teams.domain.PublicLink;
import teams.domain.Role;
import teams.domain.Team;
import teams.exception.ResourceNotFoundException;
import teams.repository.TeamRepository;

@RestController
public class PublicLinkController
implements JoinRequestValidator,
TeamValidator {
    @Autowired
    private TeamRepository teamRepository;

    @GetMapping(value={"api/teams/public-links/{publicLink}"})
    public PublicLink publicLinkInfo(@PathVariable(value="publicLink") String publicLink, FederatedUser federatedUser) throws IOException, MessagingException {
        Team team = (Team)this.teamRepository.findByPublicLinkAndPublicLinkDisabled(publicLink, false).orElseThrow(() -> new ResourceNotFoundException(String.format("PublicLink %s not found", publicLink)));
        return new PublicLink(team, federatedUser);
    }

    @PutMapping(value={"api/teams/public-links/{publicLink}"})
    public Object accept(@PathVariable(value="publicLink") String publicLink, FederatedUser federatedUser) throws IOException, MessagingException {
        Person person = federatedUser.getPerson();
        Team team = (Team)this.teamRepository.findByPublicLinkAndPublicLinkDisabled(publicLink, false).orElseThrow(() -> new ResourceNotFoundException(String.format("PublicLink %s not found", publicLink)));
        this.membershipNotAllowed(team, person);
        new Membership(Role.MEMBER, team, person, null);
        return this.lazyLoadTeam((Team)this.teamRepository.save((Object)team), Role.MEMBER, federatedUser);
    }
}

