/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import java.util.List;
import java.util.stream.Collectors;
import teams.domain.AdminMember;
import teams.domain.FederatedUser;
import teams.domain.Role;
import teams.domain.Team;

public class PublicLink {
    private List<AdminMember> admins;
    private Long id;
    private String name;
    private String description;
    private boolean alreadyMember;

    public PublicLink(Team team, FederatedUser federatedUser) {
        this.id = team.getId();
        this.name = team.getName();
        this.description = team.getDescription();
        this.alreadyMember = team.member(federatedUser.getUrn()).isPresent();
        this.admins = team.getMemberships().stream().filter(membership -> membership.getRole().equals((Object)Role.ADMIN)).map(membership -> new AdminMember(membership.getPerson())).collect(Collectors.toList());
    }

    public List<AdminMember> getAdmins() {
        return this.admins;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAlreadyMember() {
        return this.alreadyMember;
    }
}

