/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Formula;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlUtils;
import teams.api.validations.HashGenerator;
import teams.domain.ExternalTeam;
import teams.domain.Invitation;
import teams.domain.JoinRequest;
import teams.domain.Membership;

@Entity(name="teams")
public class Team
implements HashGenerator,
Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    private String urn;
    @Column
    @NotNull
    private String name;
    @Column
    private String description;
    @Column
    private String personalNote;
    @Column
    private boolean viewable;
    @Column
    private Instant created;
    @Column
    private String publicLink;
    @Column
    private boolean publicLinkDisabled = true;
    @Formula(value="(select count(*) from memberships m where m.team_id = id)")
    private int membershipCount;
    @OneToMany(mappedBy="team", orphanRemoval=true, cascade={CascadeType.ALL})
    private Set<Membership> memberships = new HashSet();
    @OneToMany(mappedBy="team", orphanRemoval=true)
    private Set<Invitation> invitations = new HashSet();
    @OneToMany(mappedBy="team", orphanRemoval=true)
    private Set<JoinRequest> joinRequests = new HashSet();
    @ManyToMany(mappedBy="teams", cascade={CascadeType.ALL})
    private Set<ExternalTeam> externalTeams = new HashSet();

    public Team(String urn, String name, String description, boolean viewable, String personalNote) {
        this.urn = urn;
        this.name = name;
        this.description = StringUtils.hasText((String)description) ? description : null;
        this.viewable = viewable;
        this.personalNote = personalNote;
        this.publicLink = this.generateHash(32, "UTF-8");
        this.created = Instant.now();
    }

    public Optional<Membership> member(String urn) {
        return this.memberships.stream().filter(membership -> membership.getUrnPerson().equals(urn)).findAny();
    }

    @JsonIgnore
    public boolean isContainsDescription() {
        return StringUtils.hasText((String)this.description);
    }

    @JsonIgnore
    public String getHtmlDescription() {
        return this.isContainsDescription() ? HtmlUtils.htmlEscape((String)this.description).replaceAll("\n", "<br/>") : "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Team team = (Team)o;
        return Objects.equals(this.id, team.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public Long getId() {
        return this.id;
    }

    public String getUrn() {
        return this.urn;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPersonalNote() {
        return this.personalNote;
    }

    public boolean isViewable() {
        return this.viewable;
    }

    public Instant getCreated() {
        return this.created;
    }

    public String getPublicLink() {
        return this.publicLink;
    }

    public boolean isPublicLinkDisabled() {
        return this.publicLinkDisabled;
    }

    public int getMembershipCount() {
        return this.membershipCount;
    }

    public Set<Membership> getMemberships() {
        return this.memberships;
    }

    public Set<Invitation> getInvitations() {
        return this.invitations;
    }

    public Set<JoinRequest> getJoinRequests() {
        return this.joinRequests;
    }

    public Set<ExternalTeam> getExternalTeams() {
        return this.externalTeams;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUrn(String urn) {
        this.urn = urn;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPersonalNote(String personalNote) {
        this.personalNote = personalNote;
    }

    public void setViewable(boolean viewable) {
        this.viewable = viewable;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    public void setPublicLink(String publicLink) {
        this.publicLink = publicLink;
    }

    public void setPublicLinkDisabled(boolean publicLinkDisabled) {
        this.publicLinkDisabled = publicLinkDisabled;
    }

    public void setMembershipCount(int membershipCount) {
        this.membershipCount = membershipCount;
    }

    public void setMemberships(Set<Membership> memberships) {
        this.memberships = memberships;
    }

    public void setInvitations(Set<Invitation> invitations) {
        this.invitations = invitations;
    }

    public void setJoinRequests(Set<JoinRequest> joinRequests) {
        this.joinRequests = joinRequests;
    }

    public void setExternalTeams(Set<ExternalTeam> externalTeams) {
        this.externalTeams = externalTeams;
    }

    public Team() {
    }
}

