/*
 * Decompiled with CFR 0.152.
 */
package teams.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import teams.api.ApiController;
import teams.api.validations.MembershipValidator;
import teams.domain.FederatedUser;
import teams.domain.Membership;
import teams.domain.MembershipProperties;
import teams.domain.Person;
import teams.domain.Role;
import teams.domain.Team;

@RestController
public class MembershipController
extends ApiController
implements MembershipValidator {
    @GetMapping(value={"api/teams/memberships/{teamId}"})
    public Map<String, Role> membership(@PathVariable(value="teamId") Long teamId, FederatedUser federatedUser) {
        Membership membership = this.membership(this.teamById(teamId, false), federatedUser.getUrn());
        return Collections.singletonMap("role", membership.getRole());
    }

    @PutMapping(value={"api/teams/memberships"})
    public Membership changeMembership(@Validated @RequestBody MembershipProperties membershipProperties, FederatedUser federatedUser) {
        Membership membership = (Membership)this.membershipRepository.findOne((Serializable)membershipProperties.getId());
        this.assertNotNull(Membership.class.getSimpleName(), (Object)membership, (Object)membershipProperties.getId());
        Team team = membership.getTeam();
        Person person = membership.getPerson();
        Role roleOfLoggedInPerson = this.membership(team, federatedUser.getUrn()).getRole();
        Role futureRole = membershipProperties.getRole();
        this.membersCanNotChangeRoles(roleOfLoggedInPerson);
        this.canNotUpgradeToMoreImportantThenYourself(roleOfLoggedInPerson, futureRole);
        this.oneAdminIsRequired(team, person, futureRole);
        this.log.info("Changing current {} membership of {} in team {} to {} by {}", new Object[]{membership.getRole(), person.getUrn(), team.getUrn(), futureRole, federatedUser.getUrn()});
        membership.setRole(futureRole);
        this.membershipRepository.save((Object)membership);
        this.log.info("Changed membership for team {} and person {} from {} to {}", new Object[]{team.getUrn(), person.getUrn(), membership.getRole(), futureRole});
        return membership;
    }

    @DeleteMapping(value={"api/teams/memberships/{id}"})
    public void deleteMembership(@PathVariable(value="id") Long id, FederatedUser federatedUser) {
        Membership membership = (Membership)this.membershipRepository.findOne((Serializable)id);
        this.assertNotNull(Membership.class.getSimpleName(), (Object)membership, (Object)id);
        Team team = membership.getTeam();
        Person person = membership.getPerson();
        Role roleOfLoggedInPerson = this.membership(team, federatedUser.getUrn()).getRole();
        this.onlyAdminsCanRemoveOthers(roleOfLoggedInPerson, person, federatedUser);
        this.oneAdminIsRequired(team, person, Role.MEMBER);
        team.getMemberships().remove(membership);
        this.membershipRepository.delete((Object)membership);
        this.log.info("Deleted current {} membership of {} in team {} by {}", new Object[]{membership.getRole(), person.getUrn(), team.getUrn(), federatedUser.getUrn()});
    }
}

