/*
 * Decompiled with CFR 0.152.
 */
package teams.repository;

import java.util.Optional;
import javax.persistence.OptimisticLockException;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import teams.domain.Membership;

@Repository
public interface MembershipRepository
extends CrudRepository<Membership, Long> {
    @EntityGraph(value="findByUrnTeamAndUrnPerson", type=EntityGraph.EntityGraphType.LOAD, attributePaths={"team.memberships"})
    public Optional<Membership> findByUrnTeamAndUrnPerson(String var1, String var2);

    @Transactional(noRollbackFor={OptimisticLockException.class})
    @Modifying
    @Query(value="DELETE FROM memberships WHERE expiry_date is not null and expiry_date < (NOW() - INTERVAL :retentionDays DAY)", nativeQuery=true)
    public int deleteExpiredMemberships(@Param(value="retentionDays") long var1);
}

