/*
 * Decompiled with CFR 0.152.
 */
package teams.shibboleth;

import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import java.time.Instant;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.util.StringUtils;
import teams.domain.Person;
import teams.repository.PersonRepository;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ShibbolethPreAuthenticatedProcessingFilter.class);
    private final PersonRepository personRepository;
    private String nonGuestsMemberOf;

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager, PersonRepository personRepository, String nonGuestsMemberOf) {
        this.personRepository = personRepository;
        this.nonGuestsMemberOf = nonGuestsMemberOf;
        this.setAuthenticationManager(authenticationManager);
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String nameId = this.getHeader("name-id", request);
        String name = this.getHeader("displayName", request);
        String email = this.getHeader("Shib-InetOrgPerson-mail", request);
        String memberOf = this.getHeader("is-member-of", request);
        name = this.normalize(name);
        Person person = new Person(nameId, name, email, !this.nonGuestsMemberOf.equals(memberOf));
        LOG.info("Person {} is attempting authentication", (Object)person);
        if (person.isValid()) {
            return this.provision(person);
        }
        return person;
    }

    protected String normalize(String name) {
        if (StringUtils.isEmpty((Object)name)) {
            return name;
        }
        String normalized = Normalizer.normalize(name, Normalizer.Form.NFD);
        normalized = normalized.replaceAll("[^\\p{ASCII}]", "");
        return normalized;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }

    private Person provision(Person person) {
        Optional personOptional = this.personRepository.findByUrnIgnoreCase(person.getUrn());
        personOptional.ifPresent(personFromDatabase -> {
            personFromDatabase.setGuest(person.isGuest());
            personFromDatabase.setEmail(person.getEmail());
            personFromDatabase.setName(person.getName());
            personFromDatabase.setLastLoginDate(Instant.now());
            LOG.info("Updating existing person after login {}", (Object)person);
            this.personRepository.save(personFromDatabase);
        });
        return personOptional.orElseGet(() -> (Person)this.personRepository.save((Object)person));
    }

    private String getHeader(String name, HttpServletRequest request) {
        String header = request.getHeader(name);
        try {
            return StringUtils.hasText((String)header) ? new String(header.getBytes("ISO8859-1"), "UTF-8") : header;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

