/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.validation.constraints.NotNull;
import teams.domain.Team;

@Entity(name="external_groups")
public class ExternalTeam
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    private String description;
    @Column
    @NotNull
    private String groupProvider;
    @Column
    @NotNull
    private String identifier;
    @Column
    @NotNull
    private String name;
    @Column(name="admin_name")
    private String adminName;
    @ManyToMany
    @JoinTable(name="team_external_groups", joinColumns={@JoinColumn(name="external_groups_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="team_id", referencedColumnName="id")})
    @JsonIgnore
    private Set<Team> teams = new HashSet();

    public ExternalTeam(String description, String groupProvider, String identifier, String name) {
        this.description = description;
        this.groupProvider = groupProvider;
        this.identifier = identifier;
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalTeam that = (ExternalTeam)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public ExternalTeam() {
    }

    public Long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroupProvider() {
        return this.groupProvider;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getAdminName() {
        return this.adminName;
    }

    public Set<Team> getTeams() {
        return this.teams;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setGroupProvider(String groupProvider) {
        this.groupProvider = groupProvider;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public void setTeams(Set<Team> teams) {
        this.teams = teams;
    }
}

