/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import java.util.List;
import java.util.stream.Collectors;
import teams.domain.AdminMember;
import teams.domain.FederatedUser;
import teams.domain.Invitation;
import teams.domain.InvitationMessage;
import teams.domain.Role;
import teams.domain.Team;

public class InvitationInfo {
    private String inviter;
    private Long expiryDate;
    private boolean accepted;
    private boolean expired;
    private boolean declined;
    private boolean alreadyMember;
    private InvitationMessage latestInvitationMessage;
    private Long teamId;
    private String teamName;
    private String teamDescription;
    private String invitationEmail;
    private Role intendedRole;
    private int daysValid;
    private List<AdminMember> admins;

    public InvitationInfo(Invitation invitation, FederatedUser federatedUser) {
        this.latestInvitationMessage = invitation.getLatestInvitationMessage();
        Team team = invitation.getTeam();
        this.teamId = team.getId();
        this.teamName = team.getName();
        this.teamDescription = team.getDescription();
        this.inviter = invitation.getLatestInvitationMessage().getPerson().getName();
        this.invitationEmail = invitation.getEmail();
        this.intendedRole = invitation.getIntendedRole();
        this.expiryDate = invitation.getExpiryDate() != null ? Long.valueOf(invitation.getExpiryDate().getEpochSecond()) : null;
        this.declined = invitation.isDeclined();
        this.accepted = invitation.isAccepted();
        this.expired = invitation.expired();
        this.alreadyMember = team.member(federatedUser.getUrn()).isPresent();
        this.daysValid = invitation.daysValid();
        this.admins = team.getMemberships().stream().filter(membership -> membership.getRole().equals((Object)Role.ADMIN)).map(membership -> new AdminMember(membership.getPerson())).collect(Collectors.toList());
    }

    public String getInviter() {
        return this.inviter;
    }

    public Long getExpiryDate() {
        return this.expiryDate;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public boolean isDeclined() {
        return this.declined;
    }

    public boolean isAlreadyMember() {
        return this.alreadyMember;
    }

    public InvitationMessage getLatestInvitationMessage() {
        return this.latestInvitationMessage;
    }

    public Long getTeamId() {
        return this.teamId;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public String getTeamDescription() {
        return this.teamDescription;
    }

    public String getInvitationEmail() {
        return this.invitationEmail;
    }

    public Role getIntendedRole() {
        return this.intendedRole;
    }

    public int getDaysValid() {
        return this.daysValid;
    }

    public List<AdminMember> getAdmins() {
        return this.admins;
    }

    public void setInviter(String inviter) {
        this.inviter = inviter;
    }

    public void setExpiryDate(Long expiryDate) {
        this.expiryDate = expiryDate;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public void setDeclined(boolean declined) {
        this.declined = declined;
    }

    public void setAlreadyMember(boolean alreadyMember) {
        this.alreadyMember = alreadyMember;
    }

    public void setLatestInvitationMessage(InvitationMessage latestInvitationMessage) {
        this.latestInvitationMessage = latestInvitationMessage;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public void setTeamDescription(String teamDescription) {
        this.teamDescription = teamDescription;
    }

    public void setInvitationEmail(String invitationEmail) {
        this.invitationEmail = invitationEmail;
    }

    public void setIntendedRole(Role intendedRole) {
        this.intendedRole = intendedRole;
    }

    public void setDaysValid(int daysValid) {
        this.daysValid = daysValid;
    }

    public void setAdmins(List<AdminMember> admins) {
        this.admins = admins;
    }

    public InvitationInfo(String inviter, Long expiryDate, boolean accepted, boolean expired, boolean declined, boolean alreadyMember, InvitationMessage latestInvitationMessage, Long teamId, String teamName, String teamDescription, String invitationEmail, Role intendedRole, int daysValid, List<AdminMember> admins) {
        this.inviter = inviter;
        this.expiryDate = expiryDate;
        this.accepted = accepted;
        this.expired = expired;
        this.declined = declined;
        this.alreadyMember = alreadyMember;
        this.latestInvitationMessage = latestInvitationMessage;
        this.teamId = teamId;
        this.teamName = teamName;
        this.teamDescription = teamDescription;
        this.invitationEmail = invitationEmail;
        this.intendedRole = intendedRole;
        this.daysValid = daysValid;
        this.admins = admins;
    }

    public InvitationInfo() {
    }
}

