/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlUtils;
import teams.domain.Person;
import teams.domain.Team;

@Entity(name="requests")
public class JoinRequest
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="team_id")
    @NotNull
    @JsonIgnore
    private Team team;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="person_id")
    private Person person;
    @Column
    private Instant created;
    @Lob
    private String message;

    public JoinRequest(Person person, Team team, String message) {
        this.person = person;
        this.team = team;
        this.message = StringUtils.hasText((String)message) ? message : null;
        this.created = Instant.now();
    }

    @JsonIgnore
    public boolean isContainsMessage() {
        return StringUtils.hasText((String)this.message);
    }

    @JsonIgnore
    public String getHtmlMessage() {
        return this.isContainsMessage() ? HtmlUtils.htmlEscape((String)this.message).replaceAll("\n", "<br/>") : "";
    }

    public Long getId() {
        return this.id;
    }

    public Team getTeam() {
        return this.team;
    }

    public Person getPerson() {
        return this.person;
    }

    public Instant getCreated() {
        return this.created;
    }

    public String getMessage() {
        return this.message;
    }

    public JoinRequest() {
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

