/*
 * Decompiled with CFR 0.152.
 */
package teams.mail;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import teams.domain.FederatedUser;
import teams.domain.Invitation;
import teams.domain.JoinRequest;
import teams.domain.Language;

public class MailBox {
    private static final String TITLE = "title";
    private static final String BASE_URL = "baseUrl";
    private static final String FEDERATED_USER = "federatedUser";
    private JavaMailSender mailSender;
    private String baseUrl;
    private String emailFrom;
    private String productName;
    private final MustacheFactory mustacheFactory = new DefaultMustacheFactory();

    public MailBox(JavaMailSender mailSender, String emailFrom, String baseUrl, String productName) {
        this.mailSender = mailSender;
        this.emailFrom = emailFrom;
        this.baseUrl = baseUrl;
        this.productName = productName;
    }

    public void sendInviteMail(Invitation invitation, FederatedUser federatedUser) throws MessagingException, IOException {
        String languageCode = invitation.getLanguage().getLanguageCode();
        String title = String.format("%s %s ", languageCode.equals(Language.DUTCH.getLanguageCode()) ? "Uitnodiging voor" : (languageCode.equals(Language.ENGLISH.getLanguageCode()) ? "Invitation for" : "Convite para"), invitation.getTeam().getName());
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(TITLE, title);
        variables.put(FEDERATED_USER, (String)federatedUser);
        variables.put("invitation", (String)invitation);
        variables.put("invitationMessage", (String)invitation.getLatestInvitationMessage());
        variables.put(BASE_URL, this.baseUrl);
        this.sendMail(String.format("mail_templates/invitation_%s.html", languageCode), title, variables, new String[]{invitation.getEmail()});
    }

    public void sendJoinRequestMail(JoinRequest joinRequest, List<String> admins, FederatedUser federatedUser) throws MessagingException, IOException {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(TITLE, this.productName);
        variables.put(FEDERATED_USER, (String)federatedUser);
        variables.put("joinRequest", (String)joinRequest);
        variables.put(BASE_URL, this.baseUrl);
        this.sendMail("mail_templates/join_request.html", String.format("Membership request for %s", joinRequest.getTeam().getName()), variables, admins.toArray(new String[admins.size()]));
    }

    public void sendJoinRequestAccepted(JoinRequest joinRequest, FederatedUser federatedUser) throws IOException, MessagingException {
        this.doSendJoinRequestAcceptedOrRejected(joinRequest, "Your request has been accepted", "join_request_accepted.html", federatedUser);
    }

    public void sendJoinRequestRejected(JoinRequest joinRequest, FederatedUser federatedUser) throws IOException, MessagingException {
        this.doSendJoinRequestAcceptedOrRejected(joinRequest, "Your request has been declined", "join_request_declined.html", federatedUser);
    }

    private void doSendJoinRequestAcceptedOrRejected(JoinRequest joinRequest, String subject, String emailTemplate, FederatedUser federatedUser) throws MessagingException, IOException {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(TITLE, this.productName);
        variables.put(FEDERATED_USER, (String)federatedUser);
        variables.put("joinRequest", (String)joinRequest);
        variables.put(BASE_URL, this.baseUrl);
        this.sendMail(String.format("mail_templates/%s", emailTemplate), subject, variables, new String[]{joinRequest.getPerson().getEmail()});
    }

    private void sendMail(String templateName, String subject, Map<String, Object> variables, String ... to) throws MessagingException, IOException {
        String html = this.mailTemplate(templateName, variables);
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, false);
        helper.setSubject(subject);
        helper.setTo(to);
        this.setText(html, helper);
        helper.setFrom(this.emailFrom);
        this.doSendMail(message);
    }

    protected void setText(String html, MimeMessageHelper helper) throws MessagingException, IOException {
        helper.setText(html, true);
    }

    protected void doSendMail(MimeMessage message) {
        new Thread(() -> this.mailSender.send(message)).start();
    }

    private String mailTemplate(String templateName, Map<String, Object> context) throws IOException {
        return this.mustacheFactory.compile(templateName).execute((Writer)new StringWriter(), context).toString();
    }
}

