/*
 * Decompiled with CFR 0.152.
 */
package teams.api;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
public class ErrorController
implements org.springframework.boot.autoconfigure.web.ErrorController {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorController.class);
    private final ErrorAttributes errorAttributes;

    @Autowired
    public ErrorController(ErrorAttributes errorAttributes) {
        this.errorAttributes = errorAttributes;
    }

    public String getErrorPath() {
        return "/error";
    }

    @RequestMapping(value={"/error"})
    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        HttpStatus statusCode;
        ServletRequestAttributes requestAttributes = new ServletRequestAttributes(request);
        Map result = this.errorAttributes.getErrorAttributes((RequestAttributes)requestAttributes, false);
        Throwable error = this.errorAttributes.getError((RequestAttributes)requestAttributes);
        if (error == null) {
            statusCode = result.containsKey("status") ? HttpStatus.valueOf((int)((Integer)result.get("status"))) : HttpStatus.INTERNAL_SERVER_ERROR;
        } else {
            LOG.error("Error occurred", error);
            ResponseStatus annotation = (ResponseStatus)AnnotationUtils.getAnnotation(error.getClass(), ResponseStatus.class);
            statusCode = annotation != null ? annotation.value() : this.status(error);
        }
        result.remove("message");
        return new ResponseEntity((Object)result, statusCode);
    }

    private HttpStatus status(Throwable throwable) {
        if (throwable instanceof AccessDeniedException) {
            return HttpStatus.FORBIDDEN;
        }
        if (throwable instanceof MethodArgumentNotValidException) {
            return HttpStatus.BAD_REQUEST;
        }
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }
}

