/*
 * Decompiled with CFR 0.152.
 */
package teams.api;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import teams.api.ApiController;
import teams.api.validations.ExternalTeamValidator;
import teams.domain.ExternalTeam;
import teams.domain.ExternalTeamProperties;
import teams.domain.FederatedUser;
import teams.domain.LinkedTeamInfo;
import teams.domain.Role;
import teams.domain.Team;
import teams.exception.ResourceNotFoundException;

@RestController
public class ExternalTeamController
extends ApiController
implements ExternalTeamValidator {
    @GetMapping(value={"api/teams/external-teams/linked-teams"})
    public Map<String, List<LinkedTeamInfo>> linkedTeams(FederatedUser federatedUser) {
        List externalTeamIdentifiers = federatedUser.getExternalTeams().stream().map(ExternalTeam::getIdentifier).collect(Collectors.toList());
        if (externalTeamIdentifiers.isEmpty()) {
            return Collections.emptyMap();
        }
        List teamsByExternalTeamIdentifiers = this.externalTeamRepository.findTeamsByExternalTeamIdentifiers(externalTeamIdentifiers);
        return teamsByExternalTeamIdentifiers.stream().map(obj -> new LinkedTeamInfo((String)String.class.cast(obj[0]), (Long)Long.class.cast(obj[1]), (String)String.class.cast(obj[2]))).collect(Collectors.groupingBy(LinkedTeamInfo::getExternalTeamIdentifier));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"api/teams/external-teams/link"})
    public Object linkTeamToExternalTeam(@Validated @RequestBody ExternalTeamProperties externalTeamProperties, FederatedUser federatedUser) {
        Team team = this.teamById(externalTeamProperties.getId(), true);
        String externalTeamIdentifier = externalTeamProperties.getExternalTeamIdentifier();
        ExternalTeam externalTeam = this.externalTeamFromFederatedUser(federatedUser, externalTeamIdentifier);
        this.externalTeamNotLinked(team, externalTeam);
        String federatedUserUrn = federatedUser.getUrn();
        Role roleOfLoggedInPerson = this.membership(team, federatedUserUrn).getRole();
        this.isAllowedToLinkExternalTeam(roleOfLoggedInPerson, team, federatedUser);
        externalTeam = this.externalTeamRepository.findByIdentifier(externalTeamIdentifier).orElse(externalTeam);
        externalTeam.setAdminName(federatedUser.getUsername());
        team.getExternalTeams().add(externalTeam);
        externalTeam.getTeams().add(team);
        this.log.info("Team {} linked to external team {} by {}", new Object[]{team.getUrn(), externalTeamIdentifier, federatedUserUrn});
        return this.lazyLoadTeam((Team)this.teamRepository.save((Object)team), roleOfLoggedInPerson, federatedUser);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"api/teams/external-teams/delink"})
    public Object delinkTeamFromExternalTeam(@Validated @RequestBody ExternalTeamProperties externalTeamProperties, FederatedUser federatedUser) {
        Team team = this.teamById(externalTeamProperties.getId(), true);
        String externalTeamIdentifier = externalTeamProperties.getExternalTeamIdentifier();
        this.externalTeamFromFederatedUser(federatedUser, externalTeamIdentifier);
        ExternalTeam externalTeam = (ExternalTeam)this.externalTeamRepository.findByIdentifier(externalTeamIdentifier).orElseThrow(() -> new ResourceNotFoundException(String.format("ExternalTeam %s does not exists. Can not be unlinked by Person %s.", externalTeamIdentifier, federatedUser.getUrn())));
        String federatedUserUrn = federatedUser.getUrn();
        Role roleOfLoggedInPerson = this.membership(team, federatedUserUrn).getRole();
        this.isAllowedToLinkExternalTeam(roleOfLoggedInPerson, team, federatedUser);
        this.externalTeamLinked(team, externalTeam);
        team.getExternalTeams().remove(externalTeam);
        externalTeam.getTeams().remove(team);
        this.log.info("Team {} de-linked from external team {} by {}", new Object[]{team.getUrn(), externalTeam.getIdentifier(), federatedUserUrn});
        Team teamSaved = (Team)this.teamRepository.save((Object)team);
        if (externalTeam.getTeams().isEmpty()) {
            this.externalTeamRepository.delete((Object)externalTeam);
        }
        return this.lazyLoadTeam(teamSaved, roleOfLoggedInPerson, federatedUser);
    }
}

