/*
 * Decompiled with CFR 0.152.
 */
package teams.api.validations;

import teams.domain.FederatedUser;
import teams.domain.Person;
import teams.domain.Role;
import teams.domain.Team;
import teams.exception.IllegalJoinRequestException;
import teams.exception.IllegalMembershipException;

public interface MembershipValidator {
    default public void membersCanNotChangeRoles(Role roleOfLoggedInPerson) {
        if (roleOfLoggedInPerson.equals((Object)Role.MEMBER)) {
            throw new IllegalMembershipException("Members are not allowed to change roles");
        }
    }

    default public void oneAdminIsRequired(Team team, Person person, Role futureRole) {
        if (futureRole.equals((Object)Role.MEMBER) || futureRole.equals((Object)Role.MANAGER)) {
            team.getMemberships().stream().filter(membership -> !membership.getUrnPerson().equals(person.getUrn())).filter(membership -> membership.getRole().equals((Object)Role.ADMIN) || membership.getRole().equals((Object)Role.OWNER)).findAny().orElseThrow(() -> new IllegalMembershipException(String.format("Not allowed to remove the only admin %s", person.getUrn())));
        }
    }

    default public void canNotUpgradeToMoreImportantThenYourself(Role roleOfLoggedInPerson, Role futureRole) {
        if (futureRole.isMoreImportant(roleOfLoggedInPerson)) {
            throw new IllegalMembershipException(String.format("Not allowed to upgrade someone more import then yourself: your role is %s and future role is %s", roleOfLoggedInPerson, futureRole));
        }
    }

    default public void onlyAdminsAndManagersCanRemoveMemberships(Role roleOfLoggedInPerson, Person personWhoIsRemoved, FederatedUser federatedUser, Role roleOfMembershipToBeDeleted) {
        boolean personWantsToDeleteHerself = personWhoIsRemoved.getUrn().equals(federatedUser.getUrn());
        if (roleOfLoggedInPerson.equals((Object)Role.MEMBER) && !personWantsToDeleteHerself) {
            throw new IllegalMembershipException("Members are not allowed to do remove memberships other then themselves");
        }
        if (roleOfLoggedInPerson.equals((Object)Role.MANAGER) && !roleOfMembershipToBeDeleted.equals((Object)Role.MEMBER) && !personWantsToDeleteHerself) {
            throw new IllegalMembershipException("Managers are only allowed to remove members");
        }
    }

    default public void privateTeamDoesNotAllowMembers(Team team, Person person) {
        if (!team.isViewable()) {
            throw new IllegalJoinRequestException(String.format("Person %s can not join private team %s", person.getUrn(), team.getUrn()));
        }
    }
}

