/*
 * Decompiled with CFR 0.152.
 */
package teams.api;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import teams.domain.FederatedUser;
import teams.domain.Invitation;
import teams.domain.Membership;
import teams.domain.Person;
import teams.domain.Team;
import teams.exception.NotAllowedException;
import teams.exception.ResourceNotFoundException;
import teams.mail.MailBox;
import teams.repository.ExternalTeamRepository;
import teams.repository.InvitationRepository;
import teams.repository.JoinRequestRepository;
import teams.repository.MembershipRepository;
import teams.repository.TeamRepository;

public abstract class ApiController {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected TeamRepository teamRepository;
    @Autowired
    protected MembershipRepository membershipRepository;
    @Autowired
    protected ExternalTeamRepository externalTeamRepository;
    @Autowired
    protected InvitationRepository invitationRepository;
    @Autowired
    protected JoinRequestRepository joinRequestRepository;
    @Autowired
    protected MailBox mailBox;

    protected Team teamById(Long id, boolean includePersons) {
        Team team = includePersons ? this.teamRepository.findFirstById(id) : this.teamRepository.findById(id);
        this.assertNotNull("Team", (Object)team, (Object)id);
        return team;
    }

    protected Membership membership(Team team, String urn) {
        return (Membership)team.member(urn).orElseThrow(() -> new NotAllowedException(String.format("Member %s is not a member of team %s.", urn, team.getUrn())));
    }

    protected void assertNotNull(String entityName, Object entity, Object id) {
        if (entity == null) {
            throw new ResourceNotFoundException(String.format("%s %s does not exist", entityName, id));
        }
    }

    protected List<Invitation> saveAndSendInvitation(List<Invitation> invitations, Team team, Person person, FederatedUser federatedUser) {
        Iterable saved = this.invitationRepository.save(invitations);
        saved.forEach(invitation -> {
            try {
                this.mailBox.sendInviteMail(invitation, federatedUser);
                this.log.info("Created invitation by {} for team {} and person {} with email {}", new Object[]{federatedUser.getPerson().getUrn(), team.getUrn(), person.getUrn(), invitation.getEmail()});
            }
            catch (IOException | MessagingException e) {
                throw new IllegalArgumentException(e);
            }
        });
        return StreamSupport.stream(saved.spliterator(), false).collect(Collectors.toList());
    }
}

