/*
 * Decompiled with CFR 0.152.
 */
package teams.voot;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.stereotype.Component;
import teams.domain.ExternalTeam;

@Component
@Profile(value={"!dev"})
public class VootClient {
    private static final Logger LOG = LoggerFactory.getLogger(VootClient.class);
    private String accessTokenUri;
    private String clientId;
    private String clientSecret;
    private String spaceDelimitedScopes;
    private String serviceUrl;
    private OAuth2RestTemplate vootService;

    public VootClient(@Value(value="${voot.accessTokenUri}") String accessTokenUri, @Value(value="${voot.clientId}") String clientId, @Value(value="${voot.clientSecret}") String clientSecret, @Value(value="${voot.scopes}") String spaceDelimitedScopes, @Value(value="${voot.serviceUrl}") String serviceUrl) {
        this.accessTokenUri = accessTokenUri;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.spaceDelimitedScopes = spaceDelimitedScopes;
        this.serviceUrl = serviceUrl;
        this.vootService = new OAuth2RestTemplate(this.vootConfiguration());
    }

    public List<ExternalTeam> teams(String personUrn) {
        String personUrnEncoded = this.encodeUrn(personUrn);
        List<ExternalTeam> externalTeams = ((List)this.vootService.exchange(RequestEntity.get((URI)URI.create(String.format("%s/internal/external-groups/%s/", this.serviceUrl, personUrnEncoded))).build(), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).getBody()).stream().map(map -> new ExternalTeam((String)String.class.cast(map.get("description")), (String)String.class.cast(map.get("sourceID")), (String)String.class.cast(map.get("id")), (String)String.class.cast(map.get("displayName")))).collect(Collectors.toList());
        LOG.debug("Result from VOOT external teams {}", externalTeams);
        return externalTeams;
    }

    public String encodeUrn(String personUrn) {
        try {
            return URLEncoder.encode(personUrn, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unexpected error in encoding urn: " + personUrn);
        }
    }

    private OAuth2ProtectedResourceDetails vootConfiguration() {
        ClientCredentialsResourceDetails details = new ClientCredentialsResourceDetails();
        details.setId("voot");
        details.setClientId(this.clientId);
        details.setClientSecret(this.clientSecret);
        details.setAccessTokenUri(this.accessTokenUri);
        details.setScope(Arrays.asList(this.spaceDelimitedScopes.split(" ")));
        return details;
    }
}

