/*
 * Decompiled with CFR 0.152.
 */
package teams.repository;

import java.util.List;
import java.util.Optional;
import javax.persistence.OptimisticLockException;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import teams.domain.Person;

@Repository
public interface PersonRepository
extends CrudRepository<Person, Long> {
    public Optional<Person> findByUrnIgnoreCase(String var1);

    public List<Person> findFirst10ByNameContainingOrEmailContainingAllIgnoreCase(String var1, String var2);

    @Transactional(noRollbackFor={OptimisticLockException.class})
    @Modifying
    @Query(value="DELETE FROM persons WHERE persons.last_login_date < (NOW() - INTERVAL :retentionDays DAY) AND NOT EXISTS (SELECT * FROM memberships WHERE persons.id = memberships.person_id) ", nativeQuery=true)
    public int deleteOrphanPersons(@Param(value="retentionDays") long var1);
}

