/*
 * Decompiled with CFR 0.152.
 */
package teams.api.validations;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import teams.domain.ExternalTeam;
import teams.domain.FederatedUser;
import teams.domain.InvitationMessage;
import teams.domain.Role;
import teams.domain.Team;
import teams.domain.TeamDetailsSummary;
import teams.domain.TeamSummary;
import teams.exception.DuplicateTeamNameException;
import teams.exception.IllegalMembershipException;
import teams.exception.InvalidTeamNameException;

public interface TeamValidator {
    default public void teamNameDuplicated(String name, List<Object> urns) {
        if (!urns.isEmpty()) {
            throw new DuplicateTeamNameException(String.format("Team with name %s already exists", name));
        }
    }

    default public String onlyAdminAllowed(Role roleOfLoggedInPerson, FederatedUser federatedUser, Team team, String action) {
        String federatedUserUrn = federatedUser.getUrn();
        if (roleOfLoggedInPerson.isLessImportant(Role.ADMIN)) {
            throw new IllegalMembershipException(String.format("Only ADMIN can %s team. Person %s is %s in team %s", action, federatedUserUrn, roleOfLoggedInPerson, team.getUrn()));
        }
        return federatedUserUrn;
    }

    default public Object lazyLoadTeam(Team team, Role role, FederatedUser user) {
        boolean superAdmin = user.getPerson().isSuperAdmin();
        team.getMemberships().forEach(membership -> membership.getPerson().isValid());
        if (Role.MEMBER.equals((Object)role) && !superAdmin) {
            return new TeamDetailsSummary(team, user);
        }
        team.getInvitations().forEach(invitation -> invitation.getInvitationMessages().forEach(InvitationMessage::getMessage));
        team.getJoinRequests().forEach(joinRequest -> joinRequest.getPerson().isValid());
        team.getExternalTeams().forEach(ExternalTeam::getIdentifier);
        return team;
    }

    default public boolean isAllowedToAcceptJoinRequest(TeamSummary teamSummary) {
        return Role.ADMIN.equals((Object)teamSummary.getRole()) || Role.MANAGER.equals((Object)teamSummary.getRole()) || Role.OWNER.equals((Object)teamSummary.getRole());
    }

    default public void invitationsCountFromQuery(List<Object[]> counts, List<TeamSummary> summaries) {
        this.consumeTeamSummaryById(counts, summaries, (teamSummary, integer) -> teamSummary.invitationsCount(integer.intValue()));
    }

    default public void joinRequestsCountFromQuery(List<Object[]> counts, List<TeamSummary> summaries) {
        this.consumeTeamSummaryById(counts, summaries, (teamSummary, integer) -> teamSummary.joinRequestsCount(integer.intValue()));
    }

    default public void consumeTeamSummaryById(List<Object[]> counts, List<TeamSummary> summaries, BiConsumer<TeamSummary, Integer> biConsumer) {
        counts.forEach(objects -> summaries.stream().filter(teamSummary -> teamSummary.getId().equals(Long.class.cast(objects[0]))).findFirst().ifPresent(teamSummary -> biConsumer.accept((TeamSummary)teamSummary, ((Number)Number.class.cast(objects[1])).intValue())));
    }

    default public void validateTeamName(String name) {
        Pattern pattern = Pattern.compile("[\\w \\-']{1,255}");
        if (!pattern.matcher(name).matches()) {
            throw new InvalidTeamNameException(String.format("Team name %s in invalid, must match %s", name, pattern.pattern()));
        }
    }
}

