/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import java.util.Set;
import java.util.stream.Collectors;
import teams.domain.ExternalTeam;
import teams.domain.FederatedUser;
import teams.domain.Membership;
import teams.domain.Role;
import teams.domain.Team;
import teams.domain.TeamSummary;

public class TeamDetailsSummary
extends TeamSummary {
    private boolean viewable;
    private Set<Membership> memberships;
    private Set<ExternalTeam> externalTeams;

    public TeamDetailsSummary(Team team, FederatedUser user) {
        super(team, user, false);
        this.viewable = team.isViewable();
        team.getMemberships().forEach(membership -> membership.getPerson().isValid());
        team.getExternalTeams().forEach(ExternalTeam::getIdentifier);
        this.memberships = team.getMemberships().stream().filter(membership -> !membership.getRole().equals((Object)Role.OWNER)).collect(Collectors.toSet());
        this.externalTeams = team.getExternalTeams();
    }

    public boolean isViewable() {
        return this.viewable;
    }

    public Set<Membership> getMemberships() {
        return this.memberships;
    }

    public Set<ExternalTeam> getExternalTeams() {
        return this.externalTeams;
    }
}

