/*
 * Decompiled with CFR 0.152.
 */
package teams;

import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import teams.domain.Invitation;
import teams.domain.Membership;
import teams.domain.Person;
import teams.repository.InvitationRepository;
import teams.repository.MembershipRepository;
import teams.repository.PersonRepository;

@Configuration
@EnableScheduling
public class Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(Scheduler.class);
    @Autowired
    private PersonRepository personRepository;
    @Autowired
    private MembershipRepository membershipRepository;
    @Autowired
    private InvitationRepository invitationRepository;
    @Value(value="${cron.node-cron-job-responsible}")
    private boolean nodeCronJobResponsible;

    @Scheduled(cron="${cron.expression}")
    public int removeExpiredMemberships() {
        return this.removeExpired(arg_0 -> ((MembershipRepository)this.membershipRepository).deleteExpiredMemberships(arg_0), Long.valueOf(0L), Membership.class);
    }

    @Scheduled(cron="${cron.expression}")
    public int removeExpiredInvitations() {
        return this.removeExpired(arg_0 -> ((InvitationRepository)this.invitationRepository).deleteExpiredInvitations(arg_0), Long.valueOf(System.currentTimeMillis() - 2592000000L), Invitation.class);
    }

    @Scheduled(cron="${cron.expression}")
    public int removeOrphanPersons() {
        return this.removeExpired(arg_0 -> ((PersonRepository)this.personRepository).deleteOrphanPersons(arg_0), Long.valueOf(1L), Person.class);
    }

    private int removeExpired(Function<Long, Integer> removeFunction, Long argument, Class clazz) {
        if (this.nodeCronJobResponsible) {
            try {
                int count = removeFunction.apply(argument);
                LOG.info(String.format("Removed %s %s that were expired", count, clazz.getName()));
                return count;
            }
            catch (Throwable t) {
                LOG.error(String.format("Unexpected exception in removing expired %s", clazz.getName()), t);
                return -1;
            }
        }
        return 0;
    }
}

