/*
 * Decompiled with CFR 0.152.
 */
package teams.api;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import teams.api.validations.TeamValidator;
import teams.domain.FederatedUser;
import teams.domain.Invitation;
import teams.domain.Membership;
import teams.domain.NewTeamProperties;
import teams.domain.Person;
import teams.domain.Role;
import teams.domain.Team;
import teams.exception.DuplicateTeamNameException;
import teams.exception.NotAllowedException;
import teams.exception.ResourceNotFoundException;
import teams.mail.MailBox;
import teams.repository.ExternalTeamRepository;
import teams.repository.InvitationRepository;
import teams.repository.JoinRequestRepository;
import teams.repository.MembershipRepository;
import teams.repository.TeamRepository;

public abstract class ApiController
implements TeamValidator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Value(value="${teams.default-stem-name}")
    private String defaultStemName;
    @Autowired
    protected TeamRepository teamRepository;
    @Autowired
    protected MembershipRepository membershipRepository;
    @Autowired
    protected ExternalTeamRepository externalTeamRepository;
    @Autowired
    protected InvitationRepository invitationRepository;
    @Autowired
    protected JoinRequestRepository joinRequestRepository;
    @Autowired
    protected MailBox mailBox;
    public static final String ADMIN_HEADER = "X-ADMIN-HEADER";

    protected Team teamById(Long id, boolean includePersons) {
        Team team = includePersons ? this.teamRepository.findFirstById(id) : (Team)this.teamRepository.findById(id).orElseThrow(() -> new ResourceNotFoundException("Team not found:" + id));
        this.assertNotNull("Team", (Object)team, (Object)id);
        return team;
    }

    protected Membership membership(Team team, String urn) {
        return (Membership)team.member(urn).orElseThrow(() -> new NotAllowedException(String.format("Member %s is not a member of team %s.", urn, team.getUrn())));
    }

    protected void assertNotNull(String entityName, Object entity, Object id) {
        if (entity == null) {
            throw new ResourceNotFoundException(String.format("%s %s does not exist", entityName, id));
        }
    }

    protected List<Invitation> saveAndSendInvitation(List<Invitation> invitations, Team team, Person person, FederatedUser federatedUser) {
        Iterable saved = this.invitationRepository.saveAll(invitations);
        saved.forEach(invitation -> {
            try {
                this.mailBox.sendInviteMail(invitation, federatedUser);
                this.log.info("Created invitation by {} for team {} and person {} with email {}", new Object[]{federatedUser.getPerson().getUrn(), team.getUrn(), person.getUrn(), invitation.getEmail()});
            }
            catch (IOException | MessagingException e) {
                throw new IllegalArgumentException(e);
            }
        });
        return StreamSupport.stream(saved.spliterator(), false).collect(Collectors.toList());
    }

    protected String constructUrn(String name) {
        return String.format("%s:%s", this.defaultStemName, name.toLowerCase().trim().replaceAll("[ ']", "_"));
    }

    protected void teamNameDuplicated(String name, List<Object> urns) {
        if (!urns.isEmpty()) {
            throw new DuplicateTeamNameException(String.format("Team with name %s already exists", name));
        }
    }

    public Team doCreateTeam(NewTeamProperties teamProperties, FederatedUser federatedUser) {
        String name = teamProperties.getName();
        this.validateTeamName(name);
        String urn = this.constructUrn(name);
        List urns = this.teamRepository.existsByUrn(urn);
        this.teamNameDuplicated(name, urns);
        Team team = new Team(urn, name, teamProperties.getDescription(), teamProperties.isViewable(), teamProperties.getPersonalNote());
        Person person = federatedUser.getPerson();
        Team savedTeam = (Team)this.teamRepository.save((Object)team);
        this.log.info("Team {} created by {}", (Object)urn, (Object)federatedUser.getUrn());
        if (!CollectionUtils.isEmpty((Map)teamProperties.getEmails())) {
            teamProperties.getEmails().forEach((email, role) -> {
                Invitation invitation = new Invitation(team, email, Role.valueOf((String)role), teamProperties.getLanguage(), null);
                invitation.addInvitationMessage(person, teamProperties.getInvitationMessage());
                Invitation saved = (Invitation)this.saveAndSendInvitation(Collections.singletonList(invitation), team, person, federatedUser).get(0);
                savedTeam.getInvitations().add(saved);
            });
        }
        return team;
    }
}

