/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.springframework.util.Assert;
import teams.domain.MembershipOrigin;
import teams.domain.Person;
import teams.domain.Role;
import teams.domain.Team;

@Entity(name="memberships")
public class Membership
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private Role role;
    @Column
    private Instant created;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="person_id")
    private Person person;
    @Column(name="urn_person")
    @NotNull
    private String urnPerson;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="team_id")
    @JsonIgnore
    private Team team;
    @Column(name="urn_team")
    @NotNull
    private String urnTeam;
    @Column
    private Instant expiryDate;
    @Column(name="origin")
    @Enumerated(value=EnumType.STRING)
    private MembershipOrigin origin;
    @Column(name="approved_by")
    private String approvedBy;

    public Membership(Role role, Team team, Person person, MembershipOrigin origin, String approvedBy) {
        this(role, team, person, null, origin, approvedBy);
    }

    public Membership(Role role, Team team, Person person, Instant expiryDate, MembershipOrigin origin, String approvedBy) {
        Assert.notNull((Object)role, (String)"Role required");
        Assert.notNull((Object)team.getUrn(), (String)"Urn team required");
        Assert.notNull((Object)person.getUrn(), (String)"Urn person required");
        this.role = role;
        this.setTeam(team);
        this.team.getMemberships().add(this);
        this.urnTeam = team.getUrn();
        this.person = person;
        this.urnPerson = person.getUrn();
        this.expiryDate = expiryDate;
        this.origin = origin;
        this.approvedBy = approvedBy;
        this.created = Instant.now();
    }

    public Long getId() {
        return this.id;
    }

    @NotNull
    public Role getRole() {
        return this.role;
    }

    public Instant getCreated() {
        return this.created;
    }

    public Person getPerson() {
        return this.person;
    }

    @NotNull
    public String getUrnPerson() {
        return this.urnPerson;
    }

    public Team getTeam() {
        return this.team;
    }

    @NotNull
    public String getUrnTeam() {
        return this.urnTeam;
    }

    public Instant getExpiryDate() {
        return this.expiryDate;
    }

    public MembershipOrigin getOrigin() {
        return this.origin;
    }

    public String getApprovedBy() {
        return this.approvedBy;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setRole(@NotNull Role role) {
        this.role = role;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public void setUrnPerson(@NotNull String urnPerson) {
        this.urnPerson = urnPerson;
    }

    @JsonIgnore
    public void setTeam(Team team) {
        this.team = team;
    }

    public void setUrnTeam(@NotNull String urnTeam) {
        this.urnTeam = urnTeam;
    }

    public void setExpiryDate(Instant expiryDate) {
        this.expiryDate = expiryDate;
    }

    public void setOrigin(MembershipOrigin origin) {
        this.origin = origin;
    }

    public void setApprovedBy(String approvedBy) {
        this.approvedBy = approvedBy;
    }

    public Membership() {
    }
}

