/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import teams.api.validations.HashGenerator;
import teams.domain.InvitationMessage;
import teams.domain.Language;
import teams.domain.Person;
import teams.domain.Role;
import teams.domain.Team;
import teams.exception.ResourceNotFoundException;

@Entity(name="invitations")
public class Invitation
implements HashGenerator,
Serializable {
    public static final long EXPIRY_DAYS = 30L;
    public static final long EXPIRY_MILLIS = 2592000000L;
    @Transient
    public static final java.util.regex.Pattern emailPattern = java.util.regex.Pattern.compile("\\S+@\\S+");
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="team_id")
    @NotNull
    @JsonIgnore
    private Team team;
    @Column(name="mailaddress", nullable=false)
    @Pattern(regexp="\\S+@\\S+")
    private @Pattern(regexp="\\S+@\\S+") String email;
    @Column(nullable=false)
    private long timestamp;
    @Column(name="invitation_uiid", nullable=false)
    @JsonIgnore
    private String invitationHash;
    @Column(name="denied")
    private boolean declined;
    @Column(name="accepted")
    private boolean accepted;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="invitation", fetch=FetchType.EAGER)
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) Set<InvitationMessage> invitationMessages = new HashSet();
    @Enumerated(value=EnumType.STRING)
    @Column(name="intended_role")
    @NotNull
    private Role intendedRole;
    @Enumerated(value=EnumType.STRING)
    private Language language;
    @Column
    private Instant expiryDate;

    public Invitation(Team team, String email, Role intendedRole, Language language, Instant expiryDate) {
        this.team = team;
        this.email = email;
        this.invitationHash = this.generateHash();
        this.timestamp = new Date().getTime();
        this.language = language;
        this.intendedRole = intendedRole;
        this.expiryDate = expiryDate;
    }

    @JsonProperty(value="expired", access=JsonProperty.Access.READ_ONLY)
    public boolean expired() {
        return this.timestamp + 2592000000L < System.currentTimeMillis();
    }

    @JsonProperty(value="daysValid", access=JsonProperty.Access.READ_ONLY)
    public int daysValid() {
        return (int)(30L - ChronoUnit.DAYS.between(Instant.ofEpochMilli(this.timestamp).atZone(ZoneId.systemDefault()).toLocalDate(), LocalDate.now()));
    }

    @JsonIgnore
    public InvitationMessage getLatestInvitationMessage() {
        return this.invitationMessages.stream().max(Comparator.comparingLong(InvitationMessage::getTimestamp)).orElseThrow(() -> new ResourceNotFoundException(String.format("Invitation for team %s and person %s has no invitation message", this.team.getUrn(), this.email)));
    }

    @JsonIgnore
    public Optional<Person> getFirstInviter() {
        return this.invitationMessages.stream().min(Comparator.comparingLong(InvitationMessage::getTimestamp)).map(invitationMessage -> invitationMessage.getPerson());
    }

    public void accepted(boolean accepted) {
        this.accepted = accepted;
        this.declined = !accepted;
    }

    public Invitation addInvitationMessage(Person person, String message) {
        InvitationMessage invitationMessage = new InvitationMessage(this, person, message);
        this.invitationMessages.add(invitationMessage);
        this.declined = false;
        return this;
    }

    public Long getId() {
        return this.id;
    }

    @NotNull
    public Team getTeam() {
        return this.team;
    }

    public String getEmail() {
        return this.email;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getInvitationHash() {
        return this.invitationHash;
    }

    public boolean isDeclined() {
        return this.declined;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    @NotNull
    public Set<InvitationMessage> getInvitationMessages() {
        return this.invitationMessages;
    }

    @NotNull
    public Role getIntendedRole() {
        return this.intendedRole;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Instant getExpiryDate() {
        return this.expiryDate;
    }

    public Invitation() {
    }
}

