/*
 * Decompiled with CFR 0.152.
 */
package teams.api;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import teams.api.ApiController;
import teams.api.TeamMatcher;
import teams.api.validations.TeamValidator;
import teams.domain.ExternalTeam;
import teams.domain.FederatedUser;
import teams.domain.Invitation;
import teams.domain.Membership;
import teams.domain.MembershipOrigin;
import teams.domain.MyTeams;
import teams.domain.NewTeamProperties;
import teams.domain.PendingJoinRequest;
import teams.domain.Person;
import teams.domain.Role;
import teams.domain.Team;
import teams.domain.TeamAutocomplete;
import teams.domain.TeamProperties;
import teams.domain.TeamSummary;
import teams.exception.NotAllowedException;
import teams.exception.ResourceNotFoundException;

@RestController
public class TeamController
extends ApiController
implements TeamValidator {
    public static final int AUTOCOMPLETE_LIMIT = 11;
    private TeamMatcher teamMatcher = new TeamMatcher();

    @GetMapping(value={"api/teams/my-teams"})
    public MyTeams myTeams(FederatedUser federatedUser) {
        List teams = this.teamRepository.findByMembershipsUrnPersonIgnoreCase(federatedUser.getUrn());
        List teamSummaries = teams.stream().map(team -> new TeamSummary(team, federatedUser, false)).collect(Collectors.toList());
        List teamIds = teamSummaries.stream().filter(arg_0 -> ((TeamController)this).isAllowedToAcceptJoinRequest(arg_0)).map(TeamSummary::getId).collect(Collectors.toList());
        List myJoinRequests = this.joinRequestRepository.findByPerson(federatedUser.getPerson());
        if (!teamIds.isEmpty()) {
            this.invitationsCountFromQuery(this.invitationRepository.countInvitationsByTeamId(teamIds), teamSummaries);
            this.joinRequestsCountFromQuery(this.joinRequestRepository.countJoinRequestsByTeamId(teamIds), teamSummaries);
        }
        List pendingJoinRequests = myJoinRequests.stream().map(PendingJoinRequest::new).collect(Collectors.toList());
        return new MyTeams(pendingJoinRequests, teamSummaries);
    }

    @GetMapping(value={"api/teams/teams/{id}"})
    public Object teamById(@PathVariable(value="id") Long id, HttpServletRequest httpServletRequest, FederatedUser federatedUser) {
        Optional membershipOptional;
        Team team = this.teamById(id, true);
        this.assertNotNull("Team", (Object)team, (Object)id);
        boolean superAdmin = federatedUser.getPerson().isSuperAdmin() && Boolean.parseBoolean(httpServletRequest.getHeader("X-ADMIN-HEADER"));
        Optional optional = membershipOptional = superAdmin ? Optional.of(new Membership()) : team.member(federatedUser.getUrn());
        if (!(membershipOptional.isPresent() || team.isViewable() || superAdmin)) {
            throw new NotAllowedException(String.format("Team %s is private and %s is not a member", id, federatedUser.getUrn()));
        }
        return membershipOptional.map(membership -> this.lazyLoadTeam(team, membership.getRole(), federatedUser)).orElse(new TeamSummary(team, federatedUser, true));
    }

    @GetMapping(value={"api/teams/teams/hash/{hash}"})
    public Object teamByHash(@PathVariable(value="hash") String hash, FederatedUser federatedUser) {
        Invitation invitation = (Invitation)this.invitationRepository.findFirstByInvitationHash(hash).orElseThrow(() -> {
            this.log.info("Invitation not found with hash {} for user {}", (Object)hash, (Object)federatedUser.getPerson().getEmail());
            return new ResourceNotFoundException(String.format("Invitation %s not found", hash));
        });
        return this.lazyLoadTeam(invitation.getTeam(), Role.MEMBER, federatedUser);
    }

    @GetMapping(value={"api/teams/teams/public-link/{public-link}"})
    public Object teamByPublicLink(@PathVariable(value="public-link") String publicLink, FederatedUser federatedUser) {
        Team team = (Team)this.teamRepository.findByPublicLinkAndPublicLinkDisabled(publicLink, false).orElseThrow(() -> {
            this.log.info("Team not found with public link {} for user {}", (Object)publicLink, (Object)federatedUser.getPerson().getEmail());
            return new ResourceNotFoundException(String.format("Team %s not found", publicLink));
        });
        return this.lazyLoadTeam(team, Role.MEMBER, federatedUser);
    }

    @GetMapping(value={"api/teams/teamIdFromUrn/{urn:.+}"})
    public Long teamIdFromUrn(@PathVariable(value="urn") String urn) {
        return (Long)this.teamRepository.findIdByUrn(urn).orElseThrow(() -> new ResourceNotFoundException(String.format("Team with urn %s does not exists", urn)));
    }

    @GetMapping(value={"api/teams/teams"})
    public List<TeamAutocomplete> teamSearch(@RequestParam(value="query") String query, HttpServletRequest httpServletRequest, FederatedUser federatedUser) {
        if (query.trim().length() == 0) {
            return Collections.emptyList();
        }
        Long id = federatedUser.getPerson().getId();
        boolean superAdmin = federatedUser.getPerson().isSuperAdmin() && Boolean.parseBoolean(httpServletRequest.getHeader("X-ADMIN-HEADER"));
        String queryUpper = ("%" + query + "%").toUpperCase();
        List autocompletes = superAdmin ? this.teamRepository.autocompleteSuperAdmin(id, queryUpper, 11) : this.teamRepository.autocomplete(id, queryUpper, id, 11);
        List<TeamAutocomplete> autoCompletes = autocompletes.stream().map(arr -> new TeamAutocomplete(arr[0].toString(), Long.valueOf(arr[1].toString()), arr[2] != null ? arr[2].toString() : "", ((Object[])arr).length == 4 && arr[3] != null ? arr[3].toString() : null)).sorted((a1, a2) -> this.teamMatcher.compare(a1.getName().toLowerCase(), a2.getName().toLowerCase(), queryUpper.toLowerCase())).collect(Collectors.toList());
        return autoCompletes;
    }

    @GetMapping(value={"api/teams/team-exists-by-name"})
    public boolean teamExistsByName(@RequestParam(value="name") String name) {
        if (name.equals("malpura")) {
            throw new IllegalArgumentException(name);
        }
        List urns = this.teamRepository.existsByUrn(this.constructUrn(name));
        List names = this.teamRepository.existsByHistoryName(name.toLowerCase());
        return !urns.isEmpty() || !names.isEmpty();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"api/teams/teams"})
    public Object createTeam(@Validated @RequestBody NewTeamProperties teamProperties, FederatedUser federatedUser) throws IOException, MessagingException {
        Team team = this.doCreateTeam(teamProperties, federatedUser);
        Person person = federatedUser.getPerson();
        Membership membership = new Membership(Role.ADMIN, team, person, MembershipOrigin.INITIAL_ADMIN, person.getName());
        this.membershipRepository.save((Object)membership);
        return this.lazyLoadTeam(team, membership.getRole(), federatedUser);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"api/teams/teams"})
    public Object updateTeam(@Validated @RequestBody TeamProperties teamProperties, FederatedUser federatedUser) {
        Team team = this.teamById(teamProperties.getId(), false);
        String federatedUserUrn = federatedUser.getUrn();
        Role roleOfLoggedInPerson = this.membership(team, federatedUserUrn).getRole();
        this.onlyAdminAllowed(roleOfLoggedInPerson, federatedUser, team, "update");
        team.setDescription(teamProperties.getDescription());
        team.setViewable(teamProperties.isViewable());
        team.setPersonalNote(teamProperties.getPersonalNote());
        team.setPublicLinkDisabled(teamProperties.isPublicLinkDisabled());
        team.setHideMembers(teamProperties.isHideMembers());
        if (teamProperties.isPublicLinkDisabled()) {
            team.setPublicLink(null);
        }
        this.log.info("Team {} updated by {}", (Object)team.getUrn(), (Object)federatedUserUrn);
        return this.lazyLoadTeam((Team)this.teamRepository.save((Object)team), roleOfLoggedInPerson, federatedUser);
    }

    @PutMapping(value={"api/teams/teams/reset-public-link/{id}"})
    public Object resetPublicLink(@PathVariable(value="id") Long id, FederatedUser federatedUser) {
        Team team = this.teamById(id, false);
        String federatedUserUrn = federatedUser.getUrn();
        Role roleOfLoggedInPerson = this.membership(team, federatedUserUrn).getRole();
        this.onlyAdminAllowed(roleOfLoggedInPerson, federatedUser, team, "resetPublicLink");
        team.resetPublicLink();
        this.log.info("Team {} resetPublicLink by {}", (Object)team.getUrn(), (Object)federatedUserUrn);
        return this.lazyLoadTeam((Team)this.teamRepository.save((Object)team), roleOfLoggedInPerson, federatedUser);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @DeleteMapping(value={"api/teams/teams/{id}"})
    public void deleteTeam(@PathVariable(value="id") Long id, FederatedUser federatedUser) {
        Team team = this.teamById(id, false);
        String federatedUserUrn = federatedUser.getUrn();
        Role roleOfLoggedInPerson = this.membership(team, federatedUserUrn).getRole();
        this.onlyAdminAllowed(roleOfLoggedInPerson, federatedUser, team, "delete");
        List externalTeams = this.externalTeamRepository.findByTeamsUrn(team.getUrn());
        externalTeams.forEach(externalTeam -> this.removeTeamFromExternalTeam(externalTeam, team));
        this.teamRepository.delete((Object)team);
        this.teamRepository.insertTeamNameHistory(team.getName().toLowerCase());
        this.log.info("Team {} deleted by {}", (Object)team.getUrn(), (Object)federatedUserUrn);
    }

    private void removeTeamFromExternalTeam(ExternalTeam externalTeam, Team team) {
        externalTeam.getTeams().remove(team);
        this.externalTeamRepository.save((Object)externalTeam);
    }
}

