/*
 * Decompiled with CFR 0.152.
 */
package teams.api.validations;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Random;

public interface HashGenerator {
    default public String generateHash() {
        return this.generateHash(128, "UTF-8");
    }

    default public String generateHash(int length, String encoding) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] aesKey = new byte[length];
        ((Random)secureRandom).nextBytes(aesKey);
        String base64 = Base64.getEncoder().encodeToString(aesKey);
        try {
            return URLEncoder.encode(base64, encoding).replaceAll("%", "");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

