/*
 * Decompiled with CFR 0.152.
 */
package teams.api.validations;

import java.util.List;
import java.util.stream.Collectors;
import teams.domain.FederatedUser;
import teams.domain.JoinRequest;
import teams.domain.Person;
import teams.domain.Role;
import teams.domain.Team;
import teams.exception.IllegalJoinRequestException;
import teams.exception.IllegalMembershipException;

public interface JoinRequestValidator {
    default public void membershipNotAllowed(Team team, Person person) {
        if (team.getMemberships().stream().anyMatch(membership -> membership.getUrnPerson().equals(person.getUrn()))) {
            throw new IllegalJoinRequestException(String.format("Person %s is already a member of team %s", person.getUrn(), team.getUrn()));
        }
    }

    default public List<String> admins(Team team) {
        List<String> admins = team.getMemberships().stream().filter(membership -> membership.getRole().equals((Object)Role.ADMIN) || membership.getRole().equals((Object)Role.OWNER)).map(membership -> membership.getPerson().getEmail()).collect(Collectors.toList());
        if (admins.isEmpty()) {
            throw new IllegalJoinRequestException(String.format("Team %s does not have an ADMIN user", team.getUrn()));
        }
        return admins;
    }

    default public void validateJoinRequest(JoinRequest joinRequest, FederatedUser federatedUser) {
        if (!joinRequest.getPerson().getUrn().equals(federatedUser.getUrn())) {
            throw new IllegalJoinRequestException(String.format("User %s is not the owner of JoinRequest %s", federatedUser.getUrn(), joinRequest.getId()));
        }
    }

    default public void membersCanNotApproveJoinRequests(Role roleOfLoggedInPerson) {
        if (roleOfLoggedInPerson.equals((Object)Role.MEMBER)) {
            throw new IllegalMembershipException("Members are not allowed to approve join requests");
        }
    }
}

