/*
 * Decompiled with CFR 0.152.
 */
package teams.voot;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Group {
    private String id;
    private String displayName;
    private String description;
    private String membership;
    private String sourceID;

    public Group(String id, String displayName, String description, String membership) {
        this(id, displayName, description, membership, null);
    }

    public Group(String id, String displayName, String description, String membership, String sourceID) {
        Assert.notNull((Object)id, (String)"Id can not be null");
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.membership = membership;
        this.sourceID = sourceID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group group = (Group)o;
        return Objects.equals(this.id, group.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMembership() {
        return this.membership;
    }

    public String getSourceID() {
        return this.sourceID;
    }
}

