/*
 * Decompiled with CFR 0.152.
 */
package teams.api.validations;

import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import teams.api.validations.InvitationValidator;
import teams.domain.ClientInvitation;
import teams.domain.FederatedUser;
import teams.domain.Invitation;
import teams.domain.Membership;
import teams.domain.Person;
import teams.domain.Role;
import teams.domain.Team;
import teams.exception.IllegalInviteException;
import teams.exception.InvitationAlreadyAcceptedException;
import teams.exception.InvitationAlreadyDeclinedException;
import teams.exception.InvitationExpiredException;
import teams.exception.NotAllowedException;

public interface InvitationValidator {
    default public void validateClientInvitation(ClientInvitation clientInvitation) {
        List emails = clientInvitation.getEmails();
        if (CollectionUtils.isEmpty((Collection)emails) && !StringUtils.hasText((String)clientInvitation.getCsvEmails())) {
            throw new IllegalInviteException("Either emails or file with emails is required");
        }
        Instant expiryDate = clientInvitation.getExpiryDate();
        Instant now = Instant.now();
        if (expiryDate != null && now.isAfter(expiryDate)) {
            throw new IllegalInviteException(String.format("Expiry date %s must be after %s", expiryDate, now));
        }
    }

    default public void validateInvitation(Invitation invitation, Person person) {
        if (invitation.expired()) {
            throw new InvitationExpiredException();
        }
        if (invitation.isAccepted() || invitation.getTeam().member(person.getUrn()).isPresent()) {
            throw new InvitationAlreadyAcceptedException();
        }
        if (invitation.isDeclined()) {
            throw new InvitationAlreadyDeclinedException();
        }
    }

    default public void membershipRequired(Team team, Person person) {
        if (team.getMemberships().stream().noneMatch(membership -> membership.getUrnPerson().equals(person.getUrn()))) {
            throw new IllegalInviteException(String.format("Person %s must be a member of team %s", person.getUrn(), team.getUrn()));
        }
    }

    default public void mustBeTeamAdminOrManager(Invitation invitation, FederatedUser federatedUser) {
        Team team = invitation.getTeam();
        Membership membership = (Membership)team.member(federatedUser.getUrn()).orElseThrow(() -> new NotAllowedException(String.format("Person %s is a member of team %s", federatedUser.getUrn(), team.getUrn())));
        if (membership.getRole().equals((Object)Role.MEMBER)) {
            throw new NotAllowedException(String.format("Person %s is a member of team %s of invitation %s", federatedUser.getUrn(), team.getUrn(), invitation.getId()));
        }
    }

    default public Role determineFutureRole(Team team, Person person, Role intendedRole) {
        Optional membershipOptional = team.member(person.getUrn());
        return membershipOptional.map(membership -> this.doDetermineFutureRole(membership.getRole(), intendedRole)).orElseThrow(() -> new IllegalInviteException(String.format("Person %s must be a member of team %s", person.getUrn(), team.getUrn())));
    }

    default public Role doDetermineFutureRole(Role role, Role intendedRole) {
        switch (1.$SwitchMap$teams$domain$Role[role.ordinal()]) {
            case 1: 
            case 2: {
                return intendedRole;
            }
            case 3: {
                return Role.MEMBER;
            }
        }
        throw new IllegalInviteException("Only ADMIN and MANAGER can invite members");
    }

    default public List<String> emails(ClientInvitation clientInvitation) throws IOException {
        this.validateClientInvitation(clientInvitation);
        List fromFile = StringUtils.hasText((String)clientInvitation.getCsvEmails()) ? Stream.of(clientInvitation.getCsvEmails().split("[,\\n\\r]")).map(email -> email.trim().replaceAll("[\\t\\n\\r]", "")).filter(email -> Invitation.emailPattern.matcher((CharSequence)email).matches()).collect(Collectors.toList()) : Collections.emptyList();
        List fromInput = clientInvitation.getEmails();
        fromInput.addAll(fromFile);
        return fromInput;
    }
}

