/*
 * Decompiled with CFR 0.152.
 */
package teams.api;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import teams.exception.MissingAttributesException;

@RestController
public class ErrorController
implements org.springframework.boot.web.servlet.error.ErrorController {
    private final ErrorAttributes errorAttributes = new DefaultErrorAttributes();

    @RequestMapping(value={"/error"})
    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        HttpStatus statusCode;
        ServletWebRequest webRequest = new ServletWebRequest(request);
        Map result = this.errorAttributes.getErrorAttributes((WebRequest)webRequest, ErrorAttributeOptions.of((ErrorAttributeOptions.Include[])new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.EXCEPTION}));
        Throwable error = this.errorAttributes.getError((WebRequest)webRequest);
        if (error == null) {
            statusCode = result.containsKey("status") ? HttpStatus.valueOf((int)((Integer)result.get("status"))) : HttpStatus.INTERNAL_SERVER_ERROR;
        } else {
            ResponseStatus annotation = (ResponseStatus)AnnotationUtils.getAnnotation(error.getClass(), ResponseStatus.class);
            HttpStatus httpStatus = statusCode = annotation != null ? annotation.value() : this.status(error);
        }
        if (error instanceof MissingAttributesException) {
            result.putAll(((MissingAttributesException)error).getMissingAttributes());
        }
        result.remove("message");
        return new ResponseEntity((Object)result, statusCode);
    }

    private HttpStatus status(Throwable throwable) {
        if (throwable instanceof AccessDeniedException) {
            return HttpStatus.FORBIDDEN;
        }
        if (throwable instanceof MethodArgumentNotValidException) {
            return HttpStatus.BAD_REQUEST;
        }
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }
}

