/*
 * Decompiled with CFR 0.152.
 */
package teams.api;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import teams.api.ApiController;
import teams.api.validations.InvitationValidator;
import teams.api.validations.MembershipValidator;
import teams.domain.ClientInvitation;
import teams.domain.ClientResendInvitation;
import teams.domain.FederatedUser;
import teams.domain.Invitation;
import teams.domain.InvitationInfo;
import teams.domain.Membership;
import teams.domain.MembershipOrigin;
import teams.domain.Person;
import teams.domain.Role;
import teams.domain.Team;
import teams.exception.ResourceNotFoundException;

@RestController
public class InvitationController
extends ApiController
implements MembershipValidator,
InvitationValidator {
    @GetMapping(value={"api/teams/invitations/{id}"})
    public Invitation invitation(@PathVariable(value="id") Long id, FederatedUser federatedUser) {
        Invitation invitation = (Invitation)this.invitationRepository.findById(id).orElseThrow(() -> new ResourceNotFoundException("Invitation not found:" + id));
        this.mustBeTeamAdminOrManager(invitation, federatedUser);
        return invitation;
    }

    @PostMapping(value={"api/teams/invitations"})
    public List<Invitation> invite(@Validated @RequestBody ClientInvitation clientInvitation, FederatedUser federatedUser) throws IOException {
        Team team = this.teamById(clientInvitation.getTeamId(), false);
        Person person = federatedUser.getPerson();
        this.membershipRequired(team, person);
        Role role = this.determineFutureRole(team, person, clientInvitation.getIntendedRole());
        this.validateClientInvitation(clientInvitation);
        List emails = this.emails(clientInvitation);
        List invitations = emails.stream().map(email -> new Invitation(team, email, role, clientInvitation.getLanguage(), clientInvitation.getExpiryDate(), clientInvitation.getMembershipExpiryDate()).addInvitationMessage(person, clientInvitation.getMessage())).collect(Collectors.toList());
        this.log.info("Saving {} invitations for emails: {}", (Object)invitations.size(), (Object)String.join((CharSequence)",", emails));
        return this.saveAndSendInvitation(invitations, team, person, federatedUser);
    }

    @DeleteMapping(value={"api/teams/invitations/{id}"})
    public void delete(@PathVariable(value="id") Long id, FederatedUser federatedUser) throws IOException, MessagingException {
        Invitation invitation = (Invitation)this.invitationRepository.findById(id).orElseThrow(() -> new ResourceNotFoundException("Invitation not found:" + id));
        this.mustBeTeamAdminOrManager(invitation, federatedUser);
        this.invitationRepository.delete((Object)invitation);
        this.log.info("Deleted invitation for team {} and person {}", (Object)invitation.getTeam().getUrn(), (Object)federatedUser.getUrn());
    }

    @PutMapping(value={"api/teams/invitations"})
    public Invitation resend(@Validated @RequestBody ClientResendInvitation resendInvitation, FederatedUser federatedUser) throws IOException, MessagingException {
        Long invitationId = resendInvitation.getId();
        Invitation invitation = (Invitation)this.invitationRepository.findById(invitationId).orElseThrow(() -> new ResourceNotFoundException("Invitation not found:" + invitationId));
        this.mustBeTeamAdminOrManager(invitation, federatedUser);
        invitation.addInvitationMessage(federatedUser.getPerson(), resendInvitation.getMessage());
        this.invitationRepository.save((Object)invitation);
        this.mailBox.sendInviteMail(invitation, federatedUser);
        this.log.info("Resend invitation for team {} and person {}", (Object)invitation.getTeam().getUrn(), (Object)federatedUser.getUrn());
        return invitation;
    }

    @GetMapping(value={"api/teams/invitations/info/{key}"})
    public InvitationInfo invitationInfo(@PathVariable(value="key") String key, FederatedUser federatedUser) {
        Invitation invitation = (Invitation)this.invitationRepository.findFirstByInvitationHash(key).orElseThrow(() -> {
            this.log.info("Invitation not found with hash '%s' for user '%s'", (Object)key, (Object)federatedUser.getPerson().getEmail());
            return new ResourceNotFoundException(String.format("Invitation %s not found", key));
        });
        return new InvitationInfo(invitation, federatedUser);
    }

    @PutMapping(value={"api/teams/invitations/accept/{key}"})
    public Team accept(@PathVariable(value="key") String key, FederatedUser federatedUser) throws IOException, MessagingException {
        Person person = federatedUser.getPerson();
        Invitation invitation = this.doAcceptOrDeny(key, true, person);
        Team team = invitation.getTeam();
        Instant expiryDate = invitation.getMembershipExpiryDate();
        new Membership(invitation.getIntendedRole(), team, person, expiryDate, MembershipOrigin.INVITATION_ACCEPTED, invitation.getFirstInviter().map(inviter -> inviter.getName()).orElse(person.getName()));
        List joinRequests = this.joinRequestRepository.findByPersonAndTeam(person, team);
        this.joinRequestRepository.deleteAll((Iterable)joinRequests);
        return (Team)this.teamRepository.save((Object)team);
    }

    @PutMapping(value={"api/teams/invitations/deny/{key}"})
    public Invitation deny(@PathVariable(value="key") String key, FederatedUser federatedUser) {
        return this.doAcceptOrDeny(key, false, federatedUser.getPerson());
    }

    private Invitation doAcceptOrDeny(String key, boolean accepted, Person person) {
        Invitation invitation = this.getInvitationByHash(key, person);
        invitation.accepted(accepted);
        this.log.info("Invitation {} for team {} and person {}", new Object[]{accepted ? "Accepted" : "Denied", invitation.getTeam().getUrn(), person.getUrn()});
        return (Invitation)this.invitationRepository.save((Object)invitation);
    }

    private Invitation getInvitationByHash(String key, Person person) {
        Invitation invitation = (Invitation)this.invitationRepository.findFirstByInvitationHash(key).orElseThrow(() -> new ResourceNotFoundException(String.format("Invitation %s not found", key)));
        this.validateInvitation(invitation, person);
        return invitation;
    }
}

