/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.validation.constraints.NotNull;
import teams.domain.EntityType;
import teams.domain.Team;

@Entity(name="applications")
public class Application
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="manage_id")
    @NotNull
    private String manageId;
    @Column(name="manage_type")
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private EntityType manageType;
    @Column(name="landing_page")
    private String landingPage;
    @ManyToMany(mappedBy="applications")
    @JsonIgnore
    private Set<Team> teams;

    public Application(String manageId, EntityType manageType) {
        this.manageId = manageId;
        this.manageType = manageType;
    }

    public Application() {
    }

    public Application(Long id, String manageId, EntityType manageType, String landingPage, Set<Team> teams) {
        this.id = id;
        this.manageId = manageId;
        this.manageType = manageType;
        this.landingPage = landingPage;
        this.teams = teams;
    }

    public Long getId() {
        return this.id;
    }

    public String getManageId() {
        return this.manageId;
    }

    public EntityType getManageType() {
        return this.manageType;
    }

    public String getLandingPage() {
        return this.landingPage;
    }

    public Set<Team> getTeams() {
        return this.teams;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setManageId(String manageId) {
        this.manageId = manageId;
    }

    public void setManageType(EntityType manageType) {
        this.manageType = manageType;
    }

    public void setLandingPage(String landingPage) {
        this.landingPage = landingPage;
    }

    @JsonIgnore
    public void setTeams(Set<Team> teams) {
        this.teams = teams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Application)) {
            return false;
        }
        Application other = (Application)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$manageId = this.getManageId();
        String other$manageId = other.getManageId();
        if (this$manageId == null ? other$manageId != null : !this$manageId.equals(other$manageId)) {
            return false;
        }
        EntityType this$manageType = this.getManageType();
        EntityType other$manageType = other.getManageType();
        return !(this$manageType == null ? other$manageType != null : !this$manageType.equals(other$manageType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Application;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $manageId = this.getManageId();
        result = result * 59 + ($manageId == null ? 43 : $manageId.hashCode());
        EntityType $manageType = this.getManageType();
        result = result * 59 + ($manageType == null ? 43 : $manageType.hashCode());
        return result;
    }
}

