/*
 * Decompiled with CFR 0.152.
 */
package teams.shibboleth;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.util.StringUtils;
import teams.domain.Person;
import teams.domain.Role;
import teams.exception.MissingAttributesException;
import teams.repository.MembershipRepository;
import teams.repository.PersonRepository;
import teams.security.SuperAdmin;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ShibbolethPreAuthenticatedProcessingFilter.class);
    private final PersonRepository personRepository;
    private final MembershipRepository membershipRepository;
    private final String nonGuestsMemberOf;
    private final SuperAdmin superAdmin;
    private final Map<String, String> config;

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager, PersonRepository personRepository, MembershipRepository membershipRepository, String nonGuestsMemberOf, SuperAdmin superAdmin, Map<String, String> config) {
        this.personRepository = personRepository;
        this.membershipRepository = membershipRepository;
        this.nonGuestsMemberOf = nonGuestsMemberOf;
        this.superAdmin = superAdmin;
        this.config = config;
        this.setAuthenticationManager(authenticationManager);
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String nameId = this.getHeader("name-id", request);
        String name = this.getHeader("displayName", request);
        String email = this.getHeader("Shib-InetOrgPerson-mail", request);
        String memberOf = this.getHeader("is-member-of", request);
        Person person = new Person(nameId, name, email, !this.nonGuestsMemberOf.equals(memberOf), false);
        LOG.info("Person {} is attempting authentication", (Object)person);
        if (person.isValid()) {
            Person provisionedPerson = this.provision(person);
            boolean isMemberButNoOwner = this.superAdmin.getUrns().stream().map(urn -> this.membershipRepository.findByUrnTeamAndUrnPerson(urn, nameId)).filter(Optional::isPresent).map(Optional::get).anyMatch(membership -> membership.getRole() != null && !membership.getRole().equals((Object)Role.OWNER));
            provisionedPerson.markAsSuperAdmin(isMemberButNoOwner);
            return provisionedPerson;
        }
        HashMap<String, Object> missingAttributes = new HashMap<String, Object>();
        ArrayList<String> missingAttributesList = new ArrayList<String>();
        if (!StringUtils.hasText((String)nameId)) {
            missingAttributesList.add("name-id");
        }
        if (!StringUtils.hasText((String)name)) {
            missingAttributesList.add("name");
        }
        if (!StringUtils.hasText((String)email)) {
            missingAttributesList.add("email");
        }
        missingAttributes.put("missing_attributes", missingAttributesList);
        missingAttributes.put("config", this.config);
        throw new MissingAttributesException(missingAttributes);
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }

    private Person provision(Person person) {
        Optional personOptional = this.personRepository.findByUrnIgnoreCase(person.getUrn());
        personOptional.ifPresent(personFromDatabase -> {
            personFromDatabase.setGuest(person.isGuest());
            personFromDatabase.setEmail(person.getEmail());
            personFromDatabase.setName(person.getName());
            personFromDatabase.setLastLoginDate(Instant.now());
            LOG.info("Updating existing person after login {}", (Object)person);
            this.personRepository.save(personFromDatabase);
        });
        return personOptional.orElseGet(() -> (Person)this.personRepository.save((Object)person));
    }

    private String getHeader(String name, HttpServletRequest request) {
        String header = request.getHeader(name);
        try {
            return StringUtils.hasText((String)header) ? new String(header.getBytes("ISO8859-1"), StandardCharsets.UTF_8) : header;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

