/*
 * Decompiled with CFR 0.152.
 */
package teams.api;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import teams.api.ApiController;
import teams.domain.Application;
import teams.domain.FederatedUser;
import teams.domain.Team;
import teams.exception.NotAllowedException;
import teams.exception.ResourceNotFoundException;
import teams.repository.TeamRepository;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(produces={"application/json"})
public class InviteController
extends ApiController {
    private static final Logger LOG = LoggerFactory.getLogger(InviteController.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private final TeamRepository teamRepository;
    private final String inviteUrl;
    private final String groupNameContext;

    public InviteController(TeamRepository teamRepository, @Value(value="${invite.url}") String inviteUrl, @Value(value="${invite.user}") String inviteUser, @Value(value="${invite.password}") String invitePassword, @Value(value="${teams.group-name-context}") String groupNameContext) {
        this.teamRepository = teamRepository;
        this.inviteUrl = inviteUrl;
        this.groupNameContext = groupNameContext;
        byte[] encodedAuth = Base64.encodeBase64((byte[])(inviteUser + ":" + invitePassword).getBytes());
        this.restTemplate.getInterceptors().add((request, body, execution) -> {
            request.getHeaders().add("Authorization", "Basic " + new String(encodedAuth));
            return execution.execute(request, body);
        });
    }

    @GetMapping(value={"/api/teams/invite-app/{id}"})
    public ResponseEntity<Team> teamDetails(@PathVariable(value="id") Long id, FederatedUser federatedUser) {
        InviteController.confirmFederatedUser((FederatedUser)federatedUser);
        return this.doTeamDetails(id);
    }

    @GetMapping(value={"/api/v1/external/invite-app/{id}"})
    public ResponseEntity<Team> teamDetails(@PathVariable(value="id") Long id) {
        return this.doTeamDetails(id);
    }

    private ResponseEntity<Team> doTeamDetails(Long id) {
        Team team = (Team)this.teamRepository.findById(id).orElseThrow(ResourceNotFoundException::new);
        team.getApplications().forEach(Application::getLandingPage);
        team.getMemberships().forEach(membership -> membership.getPerson().getSchacHomeOrganization());
        return ResponseEntity.ok((Object)team);
    }

    @PutMapping(value={"/api/v1/external/invite-app/migrate"})
    public ResponseEntity<Map<String, Integer>> migrateTeam(@RequestBody Map<String, Long> teamIdentifier) {
        return this.doMigrate(teamIdentifier);
    }

    @PutMapping(value={"/api/teams/invite-app/migrate"})
    public ResponseEntity<Map<String, Integer>> migrateTeam(@RequestBody Map<String, Long> teamIdentifier, FederatedUser federatedUser) {
        InviteController.confirmFederatedUser((FederatedUser)federatedUser);
        return this.doMigrate(teamIdentifier);
    }

    private ResponseEntity<Map<String, Integer>> doMigrate(Map<String, Long> teamIdentifier) {
        Team team = (Team)this.doTeamDetails(teamIdentifier.get("id")).getBody();
        Set applications = team.getApplications();
        if (CollectionUtils.isEmpty((Collection)applications)) {
            throw new IllegalArgumentException("No applications");
        }
        team.setUrn(this.groupNameContext + team.getUrn());
        LOG.debug("Migrating team {} {} to invite app {}", new Object[]{team.getName(), team.getUrn(), this.inviteUrl});
        ResponseEntity responseEntity = this.restTemplate.exchange(this.inviteUrl, HttpMethod.PUT, new HttpEntity((Object)team), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        this.teamRepository.delete((Object)team);
        return responseEntity;
    }

    private static void confirmFederatedUser(FederatedUser federatedUser) {
        if (!federatedUser.getPerson().isSuperAdmin()) {
            throw new NotAllowedException("Not allowed");
        }
    }
}

