/*
 * Decompiled with CFR 0.152.
 */
package teams.api;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import teams.api.ApiController;
import teams.api.validations.TeamValidator;
import teams.domain.ClientInvitation;
import teams.domain.ClientResendInvitation;
import teams.domain.FederatedUser;
import teams.domain.Invitation;
import teams.domain.InvitationMessage;
import teams.domain.Membership;
import teams.domain.MembershipProperties;
import teams.domain.NewTeamProperties;
import teams.domain.Person;
import teams.domain.Role;
import teams.domain.Team;
import teams.exception.ResourceNotFoundException;
import teams.repository.PersonRepository;

@RestController
public class SpDashboardController
extends ApiController
implements TeamValidator {
    private final PersonRepository personRepository;
    private final Map<String, String> productConfig;
    private final String spDashboardPersonUrn;
    private final String spDashboardPersonEmail;
    private final String spDashboardPersonName;

    @Autowired
    public SpDashboardController(PersonRepository personRepository, @Qualifier(value="productConfig") Map<String, String> productConfig, @Value(value="${sp_dashboard.person-urn}") String spDashboardPersonUrn, @Value(value="${sp_dashboard.email}") String spDashboardPersonEmail, @Value(value="${sp_dashboard.name}") String spDashboardPersonName) {
        this.personRepository = personRepository;
        this.productConfig = productConfig;
        this.spDashboardPersonUrn = spDashboardPersonUrn;
        this.spDashboardPersonEmail = spDashboardPersonEmail;
        this.spDashboardPersonName = spDashboardPersonName;
    }

    @GetMapping(path={"api/spdashboard/teams/{urn:.+}", "internal/teams/{urn:.+}"})
    public Team teamByUrn(@PathVariable(value="urn") String urn) {
        Team team = (Team)this.teamRepository.findByUrn(urn).orElseThrow(() -> new ResourceNotFoundException(String.format("Team with urn %s does not exists", urn)));
        team.setUrn(urn);
        team.getInvitations().forEach(invitation -> invitation.getInvitationMessages().forEach(InvitationMessage::getMessage));
        team.getMemberships().forEach(membership -> membership.getPerson().isValid());
        return team;
    }

    @PostMapping(path={"api/spdashboard/teams", "internal/teams"})
    public Team createTeam(@Validated @RequestBody NewTeamProperties teamProperties) throws IOException, MessagingException {
        return this.doCreateTeam(teamProperties, this.federatedUser());
    }

    @PutMapping(path={"api/spdashboard/memberships", "internal/memberships"})
    public ResponseEntity changeMembership(@Validated @RequestBody MembershipProperties membershipProperties) {
        Long id = membershipProperties.getId();
        Membership membership = (Membership)this.membershipRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Membership not found:" + id));
        Role futureRole = membershipProperties.getRole();
        this.log.info("Changing current {} membership of {} in team {} to {} by {}", new Object[]{membership.getRole(), membership.getPerson().getUrn(), membership.getTeam().getUrn(), futureRole, "SP Dashboard"});
        membership.setRole(futureRole);
        this.membershipRepository.save((Object)membership);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    @PostMapping(path={"api/spdashboard/invites", "internal/invites"})
    public ResponseEntity invites(@Validated @RequestBody ClientInvitation clientInvitation) {
        Person person = this.federatedUser().getPerson();
        Team team = this.teamById(clientInvitation.getTeamId(), false);
        List emails = clientInvitation.getEmails();
        List invitations = emails.stream().map(email -> new Invitation(team, email, clientInvitation.getIntendedRole(), clientInvitation.getLanguage(), clientInvitation.getExpiryDate(), null).addInvitationMessage(person, clientInvitation.getMessage())).collect(Collectors.toList());
        this.log.info("Saving {} invitations for emails: {}", (Object)invitations.size(), (Object)String.join((CharSequence)",", emails));
        this.saveAndSendInvitation(invitations, team, person, this.federatedUser());
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    @PutMapping(path={"api/spdashboard/invites", "internal/invites"})
    public ResponseEntity resend(@Validated @RequestBody ClientResendInvitation resendInvitation) throws IOException, MessagingException {
        Long invitationId = resendInvitation.getId();
        Invitation invitation = (Invitation)this.invitationRepository.findById(invitationId).orElseThrow(() -> new ResourceNotFoundException("Invitation not found:" + invitationId));
        invitation.addInvitationMessage(this.federatedUser().getPerson(), resendInvitation.getMessage());
        this.log.info("Resending mail to {}", (Object)invitation.getEmail());
        this.invitationRepository.save((Object)invitation);
        this.mailBox.sendInviteMail(invitation, this.federatedUser());
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    private FederatedUser federatedUser() {
        Person person = this.personRepository.findByUrnIgnoreCase(this.spDashboardPersonUrn).orElseGet(() -> (Person)this.personRepository.save((Object)new Person(this.spDashboardPersonUrn, this.spDashboardPersonName, this.spDashboardPersonEmail, false, false)));
        return new FederatedUser(person, (String)this.productConfig.get("productName"), this.productConfig);
    }

    @DeleteMapping(path={"api/spdashboard/teams/{id}", "internal/teams/{id}"})
    public ResponseEntity deleteTeam(@PathVariable(value="id") Long id) {
        Team team = (Team)this.teamRepository.findById(id).orElseThrow(() -> new ResourceNotFoundException("Team not found" + id));
        this.log.info("Deleting team {}", (Object)team.getName());
        this.teamRepository.delete((Object)team);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    @DeleteMapping(path={"api/spdashboard/memberships/{membershipId}", "internal/{membershipId}"})
    public ResponseEntity deleteMembership(@PathVariable(value="membershipId") Long membershipId) {
        Membership membership = (Membership)this.membershipRepository.findById((Object)membershipId).orElseThrow(() -> new ResourceNotFoundException("Membership not found:" + membershipId));
        this.log.info("Deleting membership {} from team {}", (Object)membership.getPerson().getUrn(), (Object)membership.getTeam().getUrn());
        this.membershipRepository.delete((Object)membership);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }
}

