/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import java.util.Set;
import java.util.stream.Collectors;
import teams.domain.ExternalTeam;
import teams.domain.FederatedUser;
import teams.domain.Membership;
import teams.domain.Role;
import teams.domain.Team;
import teams.domain.TeamSummary;

public class TeamDetailsSummary
extends TeamSummary {
    private final boolean viewable;
    private final Set<ExternalTeam> externalTeams;
    private final Set<Membership> memberships;

    public TeamDetailsSummary(Team team, FederatedUser user) {
        super(team, user, false);
        this.viewable = team.isViewable();
        team.getExternalTeams().forEach(ExternalTeam::getIdentifier);
        this.externalTeams = team.getExternalTeams();
        team.getMemberships().forEach(membership -> membership.getPerson().isValid());
        this.memberships = team.getMemberships().stream().filter(membership -> !membership.getRole().equals((Object)Role.OWNER)).filter(membership -> !team.isHideMembers() || membership.getPerson().getId().equals(user.getPerson().getId())).collect(Collectors.toSet());
    }

    public boolean isViewable() {
        return this.viewable;
    }

    public Set<ExternalTeam> getExternalTeams() {
        return this.externalTeams;
    }

    public Set<Membership> getMemberships() {
        return this.memberships;
    }
}

