/*
 * Decompiled with CFR 0.152.
 */
package teams.repository;

import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import teams.domain.Team;

@Repository
public interface TeamRepository
extends CrudRepository<Team, Long> {
    @EntityGraph(value="findByUrn", type=EntityGraph.EntityGraphType.LOAD, attributePaths={"memberships"})
    public Optional<Team> findByUrn(String var1);

    public Optional<Team> findByUrnOrderById(String var1);

    @EntityGraph(value="findByPublicLinkAndPublicLinkDisabled", type=EntityGraph.EntityGraphType.LOAD, attributePaths={"memberships"})
    public Optional<Team> findByPublicLinkAndPublicLinkDisabled(String var1, boolean var2);

    @EntityGraph(value="findByMembershipsUrnPersonIgnoreCase", type=EntityGraph.EntityGraphType.LOAD, attributePaths={"memberships"})
    public List<Team> findByMembershipsUrnPersonIgnoreCase(String var1);

    @Query(value="select distinct(teams.name), teams.id, teams.description, (select memberships.role from memberships where memberships.person_id = ?1 and memberships.team_id = teams.id) as role from teams as teams left outer join memberships on memberships.team_id = teams.id where upper(name) like ?2 and (teams.viewable = 1 or memberships.person_id = ?3) limit ?4", nativeQuery=true)
    public List<Object[]> autocomplete(Long var1, String var2, Long var3, int var4);

    @Query(value="select distinct(teams.name), teams.id, teams.description, (select memberships.role from memberships where memberships.person_id = ?1 and memberships.team_id = teams.id) as role from teams as teams left outer join memberships on memberships.team_id = teams.id where upper(name) like ?2 limit ?3", nativeQuery=true)
    public List<Object[]> autocompleteSuperAdmin(Long var1, String var2, int var3);

    @Query(value="select distinct(teams.urn) from teams where urn = ? LIMIT 1", nativeQuery=true)
    public List<Object> existsByUrn(String var1);

    @Query(value="select distinct(team_name_history.name) from team_name_history where name = ? LIMIT 1", nativeQuery=true)
    public List<Object> existsByHistoryName(String var1);

    @Query(value="insert into team_name_history (name) values (?)", nativeQuery=true)
    public void insertTeamNameHistory(String var1);

    @EntityGraph(value="findById", type=EntityGraph.EntityGraphType.LOAD, attributePaths={"memberships"})
    public Optional<Team> findById(Long var1);

    @EntityGraph(value="findFirstById", type=EntityGraph.EntityGraphType.LOAD, attributePaths={"memberships.person"})
    public Team findFirstById(Long var1);

    @Query(value="select t.id from teams.domain.Team t where t.urn = :urn")
    public Optional<Long> findIdByUrn(@Param(value="urn") String var1);
}

