/*
 * Decompiled with CFR 0.152.
 */
package filter;

import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.spi.FilterReply;
import java.util.ArrayList;

public class CustomThresholdFilter
extends ThresholdFilter {
    private ArrayList<Class> ignoreClasses = new ArrayList();

    public void addClazz(String clazz) {
        try {
            this.ignoreClasses.add(Class.forName(clazz));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public FilterReply decide(ILoggingEvent event) {
        FilterReply decide = super.decide(event);
        if (decide.equals((Object)FilterReply.NEUTRAL)) {
            IThrowableProxy throwableProxy = event.getThrowableProxy();
            if (throwableProxy == null) {
                return FilterReply.NEUTRAL;
            }
            if (!(throwableProxy instanceof ThrowableProxy)) {
                return FilterReply.NEUTRAL;
            }
            ThrowableProxy throwableProxyImpl = (ThrowableProxy)throwableProxy;
            Throwable throwable = throwableProxyImpl.getThrowable();
            if (throwable != null && this.ignoreClasses.contains(throwable.getClass())) {
                return FilterReply.DENY;
            }
        }
        return decide;
    }
}

