/*
 * Decompiled with CFR 0.152.
 */
package tiqr.org.model;

import java.io.Serializable;
import java.time.Instant;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import tiqr.org.model.EnrollmentStatus;

@Document(collection="enrollments")
public class Enrollment
implements Serializable {
    @Id
    private String id;
    private String key;
    private String enrollmentSecret;
    private String userID;
    private String userDisplayName;
    private EnrollmentStatus status;
    private Instant created;
    private Instant updated;

    public Enrollment(String key, String userID, String userDisplayName, EnrollmentStatus status) {
        this.key = key;
        this.userID = userID;
        this.userDisplayName = userDisplayName;
        this.status = status;
        this.created = Instant.now();
        this.updated = Instant.now();
    }

    public void update(EnrollmentStatus newStatus) {
        this.status = newStatus;
        this.updated = Instant.now();
    }

    public void setEnrollmentSecret(String enrollmentSecret) {
        this.enrollmentSecret = enrollmentSecret;
        this.updated = Instant.now();
    }

    @Generated
    public Enrollment() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getEnrollmentSecret() {
        return this.enrollmentSecret;
    }

    @Generated
    public String getUserID() {
        return this.userID;
    }

    @Generated
    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    @Generated
    public EnrollmentStatus getStatus() {
        return this.status;
    }

    @Generated
    public Instant getCreated() {
        return this.created;
    }

    @Generated
    public Instant getUpdated() {
        return this.updated;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setUserID(String userID) {
        this.userID = userID;
    }

    @Generated
    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    @Generated
    public void setStatus(EnrollmentStatus status) {
        this.status = status;
    }

    @Generated
    public void setCreated(Instant created) {
        this.created = created;
    }

    @Generated
    public void setUpdated(Instant updated) {
        this.updated = updated;
    }
}

