/*
 * Decompiled with CFR 0.152.
 */
package tiqr.org.push;

import com.eatthepath.pushy.apns.ApnsClient;
import com.eatthepath.pushy.apns.ApnsClientBuilder;
import com.eatthepath.pushy.apns.ApnsPushNotification;
import com.eatthepath.pushy.apns.PushNotificationResponse;
import com.eatthepath.pushy.apns.auth.ApnsSigningKey;
import com.eatthepath.pushy.apns.util.SimpleApnsPayloadBuilder;
import com.eatthepath.pushy.apns.util.SimpleApnsPushNotification;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import tiqr.org.model.Registration;
import tiqr.org.push.PushNotificationException;
import tiqr.org.push.PushNotifier;

public class APNS
implements PushNotifier {
    private static final Log LOG = LogFactory.getLog(APNS.class);
    final ApnsClient apnsClient;

    public APNS(String serverHost, int port, Resource signingKey, Optional<Resource> serverCertificateChain, String teamId, String keyId) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        ApnsClientBuilder apnsClientBuilder = new ApnsClientBuilder().setApnsServer(serverHost, port).setSigningKey(ApnsSigningKey.loadFromInputStream((InputStream)signingKey.getInputStream(), (String)teamId, (String)keyId));
        if (serverCertificateChain.isPresent()) {
            apnsClientBuilder.setTrustedServerCertificateChain(serverCertificateChain.get().getInputStream());
        }
        this.apnsClient = apnsClientBuilder.build();
    }

    @Override
    public String push(Registration registration) {
        String notificationAddress = registration.getNotificationAddress();
        String userId = registration.getUserId();
        SimpleApnsPayloadBuilder payloadBuilder = new SimpleApnsPayloadBuilder();
        payloadBuilder.setCategoryName("tiqr");
        String payload = payloadBuilder.build();
        SimpleApnsPushNotification pushNotification = new SimpleApnsPushNotification(notificationAddress, "tiqr", payload);
        try {
            PushNotificationResponse response = (PushNotificationResponse)this.apnsClient.sendNotification((ApnsPushNotification)pushNotification).get();
            String id = response.getApnsId().toString();
            LOG.info((Object)String.format("Push notification APNS send for user %s and token %s", userId, notificationAddress));
            return id;
        }
        catch (InterruptedException | NullPointerException | ExecutionException e) {
            throw new PushNotificationException(String.format("Error in push notification APNS for user %s and token %s", userId, notificationAddress), e);
        }
    }
}

