/*
 * Decompiled with CFR 0.152.
 */
package tiqr.org.push;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.Notification;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import tiqr.org.model.Registration;
import tiqr.org.push.PushNotificationException;
import tiqr.org.push.PushNotifier;

public class GCM
implements PushNotifier {
    private static final Log LOG = LogFactory.getLog(GCM.class);
    private final FirebaseMessaging firebaseMessaging;

    public GCM(Resource firebaseServiceAccount, String appName) throws IOException {
        GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)firebaseServiceAccount.getInputStream());
        FirebaseOptions firebaseOptions = FirebaseOptions.builder().setCredentials(googleCredentials).build();
        FirebaseApp app = FirebaseApp.initializeApp((FirebaseOptions)firebaseOptions, (String)appName);
        this.firebaseMessaging = FirebaseMessaging.getInstance((FirebaseApp)app);
    }

    @Override
    public String push(Registration registration) {
        String notificationAddress = registration.getNotificationAddress();
        String userId = registration.getUserId();
        Notification notification = Notification.builder().setBody("tiqr-java-connector").build();
        Message message = Message.builder().setToken(notificationAddress).setNotification(notification).build();
        try {
            String uuid = this.firebaseMessaging.send(message);
            LOG.info((Object)String.format("Push notification GCM send for user %s and token %s", userId, notificationAddress));
            return uuid;
        }
        catch (FirebaseMessagingException e) {
            throw new PushNotificationException(String.format("Error in push notification GCM for user %s and token %s", userId, notificationAddress), e);
        }
    }
}

